/*
 * Decompiled with CFR 0.152.
 */
package ratpack.session;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.AsciiString;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import javax.inject.Named;
import ratpack.func.Action;
import ratpack.guice.ConfigurableModule;
import ratpack.guice.RequestScoped;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.session.JavaSessionSerializer;
import ratpack.session.Session;
import ratpack.session.SessionCookieConfig;
import ratpack.session.SessionId;
import ratpack.session.SessionIdGenerator;
import ratpack.session.SessionSerializer;
import ratpack.session.SessionStore;
import ratpack.session.internal.CookieBasedSessionId;
import ratpack.session.internal.DefaultSession;
import ratpack.session.internal.DefaultSessionIdGenerator;
import ratpack.session.internal.JavaBuiltinSessionSerializer;
import ratpack.session.internal.LocalMemorySessionStore;
import ratpack.util.Types;

public class SessionModule
extends ConfigurableModule<SessionCookieConfig> {
    public static final String LOCAL_MEMORY_SESSION_CACHE_BINDING_NAME = "localMemorySessionCache";
    public static final Key<Cache<AsciiString, ByteBuf>> LOCAL_MEMORY_SESSION_CACHE_BINDING_KEY = Key.get((TypeLiteral)new TypeLiteral<Cache<AsciiString, ByteBuf>>(){}, (Annotation)Names.named((String)"localMemorySessionCache"));

    public static Action<Binder> memoryStore(Consumer<? super CacheBuilder<AsciiString, ByteBuf>> config) {
        return b -> SessionModule.memoryStore(b, config);
    }

    public static void memoryStore(Binder binder, Consumer<? super CacheBuilder<AsciiString, ByteBuf>> config) {
        binder.bind(LOCAL_MEMORY_SESSION_CACHE_BINDING_KEY).toProvider(() -> {
            CacheBuilder cacheBuilder = (CacheBuilder)Types.cast((Object)CacheBuilder.newBuilder());
            cacheBuilder.removalListener(n -> ((ByteBuf)n.getValue()).release());
            config.accept((CacheBuilder<AsciiString, ByteBuf>)cacheBuilder);
            return cacheBuilder.build();
        }).in(Scopes.SINGLETON);
    }

    protected void configure() {
        SessionModule.memoryStore(this.binder(), s -> s.maximumSize(1000L));
    }

    @Provides
    @Singleton
    SessionStore sessionStoreAdapter(@Named(value="localMemorySessionCache") Cache<AsciiString, ByteBuf> cache) {
        return new LocalMemorySessionStore(cache);
    }

    @Provides
    SessionIdGenerator sessionIdGenerator() {
        return new DefaultSessionIdGenerator();
    }

    @Provides
    @RequestScoped
    SessionId sessionId(Request request, Response response, SessionIdGenerator idGenerator, SessionCookieConfig cookieConfig) {
        return new CookieBasedSessionId(request, response, idGenerator, cookieConfig);
    }

    @Provides
    SessionSerializer sessionValueSerializer(JavaSessionSerializer sessionSerializer) {
        return sessionSerializer;
    }

    @Provides
    JavaSessionSerializer javaSessionSerializer() {
        return new JavaBuiltinSessionSerializer();
    }

    @Provides
    @RequestScoped
    Session sessionAdapter(SessionId sessionId, SessionStore store, Response response, ByteBufAllocator bufferAllocator, SessionSerializer defaultSerializer, JavaSessionSerializer javaSerializer) {
        return new DefaultSession(sessionId, bufferAllocator, store, response, defaultSerializer, javaSerializer);
    }
}

