/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util.unsafe;

import rx.internal.util.atomic.LinkedQueueNode;
import rx.internal.util.unsafe.BaseLinkedQueue;
import rx.internal.util.unsafe.UnsafeAccess;

public final class MpscLinkedQueue<E>
extends BaseLinkedQueue<E> {
    public MpscLinkedQueue() {
        this.consumerNode = new LinkedQueueNode();
        this.xchgProducerNode(this.consumerNode);
    }

    protected final LinkedQueueNode<E> xchgProducerNode(LinkedQueueNode<E> newVal) {
        LinkedQueueNode oldVal;
        while (!UnsafeAccess.UNSAFE.compareAndSwapObject(this, P_NODE_OFFSET, oldVal = this.producerNode, newVal)) {
        }
        return oldVal;
    }

    @Override
    public final boolean offer(E nextValue) {
        if (nextValue == null) {
            throw new IllegalArgumentException("null elements not allowed");
        }
        LinkedQueueNode<E> nextNode = new LinkedQueueNode<E>(nextValue);
        LinkedQueueNode<E> prevProducerNode = this.xchgProducerNode(nextNode);
        prevProducerNode.soNext(nextNode);
        return true;
    }

    @Override
    public final E poll() {
        LinkedQueueNode currConsumerNode = this.lpConsumerNode();
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            Object nextValue = nextNode.getAndNullValue();
            this.spConsumerNode(nextNode);
            return nextValue;
        }
        if (currConsumerNode != this.lvProducerNode()) {
            while ((nextNode = currConsumerNode.lvNext()) == null) {
            }
            Object nextValue = nextNode.getAndNullValue();
            this.consumerNode = nextNode;
            return nextValue;
        }
        return null;
    }

    @Override
    public final E peek() {
        LinkedQueueNode currConsumerNode = this.consumerNode;
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            return nextNode.lpValue();
        }
        if (currConsumerNode != this.lvProducerNode()) {
            while ((nextNode = currConsumerNode.lvNext()) == null) {
            }
            return nextNode.lpValue();
        }
        return null;
    }
}

