/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func1;
import rx.functions.Func2;

public final class OperatorTakeWhile<T>
implements Observable.Operator<T, T> {
    private final Func2<? super T, ? super Integer, Boolean> predicate;

    public OperatorTakeWhile(final Func1<? super T, Boolean> underlying) {
        this(new Func2<T, Integer, Boolean>(){

            @Override
            public Boolean call(T input, Integer index) {
                return (Boolean)underlying.call(input);
            }
        });
    }

    public OperatorTakeWhile(Func2<? super T, ? super Integer, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        Subscriber s = new Subscriber<T>(subscriber, false){
            private int counter;
            private boolean done;
            {
                super(x0, x1);
                this.counter = 0;
                this.done = false;
            }

            @Override
            public void onNext(T t) {
                boolean isSelected;
                try {
                    isSelected = (Boolean)OperatorTakeWhile.this.predicate.call(t, this.counter++);
                }
                catch (Throwable e) {
                    this.done = true;
                    Exceptions.throwIfFatal(e);
                    subscriber.onError(OnErrorThrowable.addValueAsLastCause(e, t));
                    this.unsubscribe();
                    return;
                }
                if (isSelected) {
                    subscriber.onNext(t);
                } else {
                    this.done = true;
                    subscriber.onCompleted();
                    this.unsubscribe();
                }
            }

            @Override
            public void onCompleted() {
                if (!this.done) {
                    subscriber.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (!this.done) {
                    subscriber.onError(e);
                }
            }
        };
        subscriber.add(s);
        return s;
    }
}

