/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.schedulers.Timestamped;

public class OperatorSkipLastTimed<T>
implements Observable.Operator<T, T> {
    final long timeInMillis;
    final Scheduler scheduler;

    public OperatorSkipLastTimed(long time, TimeUnit unit, Scheduler scheduler) {
        this.timeInMillis = unit.toMillis(time);
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        return new Subscriber<T>(subscriber){
            private Deque<Timestamped<T>> buffer;
            {
                super(x0);
                this.buffer = new ArrayDeque();
            }

            private void emitItemsOutOfWindow(long now) {
                Timestamped v;
                long limit = now - OperatorSkipLastTimed.this.timeInMillis;
                while (!this.buffer.isEmpty() && (v = this.buffer.getFirst()).getTimestampMillis() < limit) {
                    this.buffer.removeFirst();
                    subscriber.onNext(v.getValue());
                }
            }

            @Override
            public void onNext(T value) {
                long now = OperatorSkipLastTimed.this.scheduler.now();
                this.emitItemsOutOfWindow(now);
                this.buffer.offerLast(new Timestamped(now, value));
            }

            @Override
            public void onError(Throwable e) {
                subscriber.onError(e);
            }

            @Override
            public void onCompleted() {
                this.emitItemsOutOfWindow(OperatorSkipLastTimed.this.scheduler.now());
                subscriber.onCompleted();
            }
        };
    }
}

