/*
 * Decompiled with CFR 0.152.
 */
package rx.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import rx.annotations.Experimental;

public final class CompositeException
extends RuntimeException {
    private static final long serialVersionUID = 3026362227162912146L;
    private final List<Throwable> exceptions;
    private final String message;
    private Throwable cause = null;

    @Deprecated
    public CompositeException(String messagePrefix, Collection<? extends Throwable> errors) {
        LinkedHashSet<Throwable> deDupedExceptions = new LinkedHashSet<Throwable>();
        ArrayList<Throwable> _exceptions = new ArrayList<Throwable>();
        if (errors != null) {
            for (Throwable throwable : errors) {
                if (throwable instanceof CompositeException) {
                    deDupedExceptions.addAll(((CompositeException)throwable).getExceptions());
                    continue;
                }
                if (throwable != null) {
                    deDupedExceptions.add(throwable);
                    continue;
                }
                deDupedExceptions.add(new NullPointerException());
            }
        } else {
            deDupedExceptions.add(new NullPointerException());
        }
        _exceptions.addAll(deDupedExceptions);
        this.exceptions = Collections.unmodifiableList(_exceptions);
        this.message = this.exceptions.size() + " exceptions occurred. ";
    }

    public CompositeException(Collection<? extends Throwable> errors) {
        this(null, errors);
    }

    @Experimental
    public CompositeException(Throwable ... errors) {
        LinkedHashSet<Throwable> deDupedExceptions = new LinkedHashSet<Throwable>();
        ArrayList<Throwable> _exceptions = new ArrayList<Throwable>();
        if (errors != null) {
            for (Throwable ex : errors) {
                if (ex instanceof CompositeException) {
                    deDupedExceptions.addAll(((CompositeException)ex).getExceptions());
                    continue;
                }
                if (ex != null) {
                    deDupedExceptions.add(ex);
                    continue;
                }
                deDupedExceptions.add(new NullPointerException());
            }
        } else {
            deDupedExceptions.add(new NullPointerException());
        }
        _exceptions.addAll(deDupedExceptions);
        this.exceptions = Collections.unmodifiableList(_exceptions);
        this.message = this.exceptions.size() + " exceptions occurred. ";
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public synchronized Throwable getCause() {
        if (this.cause == null) {
            CompositeExceptionCausalChain _cause = new CompositeExceptionCausalChain();
            HashSet<Throwable> seenCauses = new HashSet<Throwable>();
            Throwable chain = _cause;
            for (Throwable e : this.exceptions) {
                if (seenCauses.contains(e)) continue;
                seenCauses.add(e);
                List<Throwable> listOfCauses = this.getListOfCauses(e);
                for (Throwable child : listOfCauses) {
                    if (seenCauses.contains(child)) {
                        e = new RuntimeException("Duplicate found in causal chain so cropping to prevent loop ...");
                        continue;
                    }
                    seenCauses.add(child);
                }
                try {
                    chain.initCause(e);
                    chain = chain.getCause();
                }
                catch (Throwable t) {
                    chain = e;
                }
            }
            this.cause = _cause;
        }
        return this.cause;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new WrappedPrintStream(s));
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(new WrappedPrintWriter(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackTrace(PrintStreamOrWriter s) {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this).append("\n");
        for (StackTraceElement myStackElement : this.getStackTrace()) {
            bldr.append("\tat ").append(myStackElement).append("\n");
        }
        int i = 1;
        for (Throwable ex : this.exceptions) {
            bldr.append("  ComposedException ").append(i).append(" :").append("\n");
            this.appendStackTrace(bldr, ex, "\t");
            ++i;
        }
        Object object = s.lock();
        synchronized (object) {
            s.println(bldr.toString());
        }
    }

    private void appendStackTrace(StringBuilder bldr, Throwable ex, String prefix) {
        bldr.append(prefix).append(ex).append("\n");
        for (StackTraceElement stackElement : ex.getStackTrace()) {
            bldr.append("\t\tat ").append(stackElement).append("\n");
        }
        if (ex.getCause() != null) {
            bldr.append("\tCaused by: ");
            this.appendStackTrace(bldr, ex.getCause(), "");
        }
    }

    private List<Throwable> getListOfCauses(Throwable ex) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        Throwable root = ex.getCause();
        if (root == null) {
            return list;
        }
        while (true) {
            list.add(root);
            if (root.getCause() == null) {
                return list;
            }
            root = root.getCause();
        }
    }

    static final class CompositeExceptionCausalChain
    extends RuntimeException {
        private static final long serialVersionUID = 3875212506787802066L;
        static String MESSAGE = "Chain of Causes for CompositeException In Order Received =>";

        CompositeExceptionCausalChain() {
        }

        @Override
        public String getMessage() {
            return MESSAGE;
        }
    }

    private static class WrappedPrintWriter
    extends PrintStreamOrWriter {
        private final PrintWriter printWriter;

        WrappedPrintWriter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        Object lock() {
            return this.printWriter;
        }

        @Override
        void println(Object o) {
            this.printWriter.println(o);
        }
    }

    private static class WrappedPrintStream
    extends PrintStreamOrWriter {
        private final PrintStream printStream;

        WrappedPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        Object lock() {
            return this.printStream;
        }

        @Override
        void println(Object o) {
            this.printStream.println(o);
        }
    }

    private static abstract class PrintStreamOrWriter {
        private PrintStreamOrWriter() {
        }

        abstract Object lock();

        abstract void println(Object var1);
    }
}

