/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.interop.sync;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/realm/internal/interop/sync/PartitionValue;", "", "stringValue", "", "(Ljava/lang/String;)V", "longValue", "", "(J)V", "(Ljava/lang/String;Ljava/lang/Long;)V", "Ljava/lang/Long;", "valueType", "Lio/realm/internal/interop/sync/PartitionValue$ValueType;", "asLong", "asString", "asSyncPartition", "checkValidType", "", "expectedValueType", "equals", "", "other", "hashCode", "", "ValueType", "cinterop_release"})
public final class PartitionValue {
    @Nullable
    private final String stringValue;
    @Nullable
    private final Long longValue;
    @NotNull
    private final ValueType valueType;

    private PartitionValue(String stringValue, Long longValue) {
        ValueType valueType;
        this.stringValue = stringValue;
        this.longValue = longValue;
        if (this.stringValue != null) {
            valueType = ValueType.STRING;
        } else if (this.longValue != null) {
            valueType = ValueType.LONG;
        } else {
            throw new IllegalStateException("Wrong partition value");
        }
        this.valueType = valueType;
    }

    /* synthetic */ PartitionValue(String string, Long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            l = null;
        }
        this(string, l);
    }

    public PartitionValue(@NotNull String stringValue) {
        Intrinsics.checkNotNullParameter((Object)stringValue, (String)"stringValue");
        this(stringValue, null);
    }

    public PartitionValue(long longValue) {
        this(null, longValue);
    }

    public final long asLong() {
        this.checkValidType(ValueType.LONG);
        Unit it = Unit.INSTANCE;
        boolean bl = false;
        Long l = this.longValue;
        Intrinsics.checkNotNull((Object)l);
        return l;
    }

    @NotNull
    public final String asString() {
        this.checkValidType(ValueType.STRING);
        Unit it = Unit.INSTANCE;
        boolean bl = false;
        String string = this.stringValue;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String asSyncPartition() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.valueType.ordinal()]) {
            case 1: {
                string = '\"' + this.asString() + '\"';
                break;
            }
            case 2: {
                string = "{\"$numberLong\":\"" + this.asLong() + "\"}";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PartitionValue && Intrinsics.areEqual((Object)this.asSyncPartition(), (Object)((PartitionValue)other).asSyncPartition());
    }

    public int hashCode() {
        int n;
        String string = this.stringValue;
        int result = string == null ? 0 : (n = string.hashCode());
        Long l = this.longValue;
        result = 31 * result + (l == null ? 0 : (n = ((Object)l).hashCode()));
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    private final void checkValidType(ValueType expectedValueType) {
        if (expectedValueType != this.valueType) {
            throw new IllegalStateException("This partition value is not a " + expectedValueType.name() + " but a " + this.valueType.name());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.valueType.ordinal()]) {
            case 1: {
                if (this.stringValue != null) break;
                throw new IllegalStateException("String value cannot be null");
            }
            case 2: {
                if (this.longValue != null) break;
                throw new IllegalStateException("Long value cannot be null");
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/realm/internal/interop/sync/PartitionValue$ValueType;", "", "(Ljava/lang/String;I)V", "STRING", "LONG", "cinterop_release"})
    private static final class ValueType
    extends Enum<ValueType> {
        public static final /* enum */ ValueType STRING = new ValueType();
        public static final /* enum */ ValueType LONG = new ValueType();
        private static final /* synthetic */ ValueType[] $VALUES;

        public static ValueType[] values() {
            return (ValueType[])$VALUES.clone();
        }

        public static ValueType valueOf(String value) {
            return Enum.valueOf(ValueType.class, value);
        }

        static {
            $VALUES = valueTypeArray = new ValueType[]{ValueType.STRING, ValueType.LONG};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            nArray[ValueType.STRING.ordinal()] = 1;
            nArray[ValueType.LONG.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

