/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.interop;

import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001:\u0001\u001aBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lio/realm/kotlin/internal/interop/SyncConnectionParams;", "", "sdkVersion", "", "platform", "platformVersion", "cpuArch", "device", "deviceVersion", "framework", "Lio/realm/kotlin/internal/interop/SyncConnectionParams$Runtime;", "frameworkVersion", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/realm/kotlin/internal/interop/SyncConnectionParams$Runtime;Ljava/lang/String;)V", "getCpuArch", "()Ljava/lang/String;", "getDevice", "getDeviceVersion", "getFramework", "getFrameworkVersion", "getPlatform", "getPlatformVersion", "sdkName", "getSdkName", "getSdkVersion", "normalizeCpuArch", "normalizePlatformValue", "Runtime", "cinterop_release"})
public final class SyncConnectionParams {
    @NotNull
    private final String sdkName;
    @NotNull
    private final String sdkVersion;
    @NotNull
    private final String platform;
    @NotNull
    private final String platformVersion;
    @NotNull
    private final String cpuArch;
    @NotNull
    private final String device;
    @NotNull
    private final String deviceVersion;
    @NotNull
    private final String framework;
    @NotNull
    private final String frameworkVersion;

    public SyncConnectionParams(@NotNull String sdkVersion, @NotNull String platform, @NotNull String platformVersion, @NotNull String cpuArch, @NotNull String device, @NotNull String deviceVersion, @NotNull Runtime framework, @NotNull String frameworkVersion) {
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)platformVersion, (String)"platformVersion");
        Intrinsics.checkNotNullParameter((Object)cpuArch, (String)"cpuArch");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)deviceVersion, (String)"deviceVersion");
        Intrinsics.checkNotNullParameter((Object)((Object)framework), (String)"framework");
        Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
        this.sdkName = "Kotlin";
        this.sdkVersion = sdkVersion;
        this.platform = this.normalizePlatformValue(platform);
        this.platformVersion = platformVersion;
        this.cpuArch = this.normalizeCpuArch(cpuArch);
        this.device = device;
        this.deviceVersion = deviceVersion;
        this.framework = framework.getDescription();
        this.frameworkVersion = frameworkVersion;
    }

    @NotNull
    public final String getSdkName() {
        return this.sdkName;
    }

    @NotNull
    public final String getSdkVersion() {
        return this.sdkVersion;
    }

    @NotNull
    public final String getPlatform() {
        return this.platform;
    }

    @NotNull
    public final String getPlatformVersion() {
        return this.platformVersion;
    }

    @NotNull
    public final String getCpuArch() {
        return this.cpuArch;
    }

    @NotNull
    public final String getDevice() {
        return this.device;
    }

    @NotNull
    public final String getDeviceVersion() {
        return this.deviceVersion;
    }

    @NotNull
    public final String getFramework() {
        return this.framework;
    }

    @NotNull
    public final String getFrameworkVersion() {
        return this.frameworkVersion;
    }

    private final String normalizeCpuArch(String cpuArch) {
        if (((CharSequence)cpuArch).length() == 0) {
            return "";
        }
        return Regex.find$default((Regex)new Regex("x86.64", RegexOption.IGNORE_CASE), (CharSequence)cpuArch, (int)0, (int)2, null) != null ? "x86_64" : (StringsKt.contains((CharSequence)cpuArch, (CharSequence)"x86", (boolean)true) ? "x86" : (Regex.find$default((Regex)new Regex("v7a", RegexOption.IGNORE_CASE), (CharSequence)cpuArch, (int)0, (int)2, null) != null ? "armeabi-v7a" : (Regex.find$default((Regex)new Regex("arm64", RegexOption.IGNORE_CASE), (CharSequence)cpuArch, (int)0, (int)2, null) != null || StringsKt.equals((String)cpuArch, (String)"aarch64", (boolean)true) ? "arm64" : "Unknown (" + cpuArch + ')')));
    }

    private final String normalizePlatformValue(String platform) {
        if (((CharSequence)platform).length() == 0) {
            return "";
        }
        return StringsKt.contains((CharSequence)platform, (CharSequence)"windows", (boolean)true) ? "Windows" : (StringsKt.contains((CharSequence)platform, (CharSequence)"linux", (boolean)true) ? "Linux" : (Regex.find$default((Regex)new Regex("mac( )?os", SetsKt.setOf((Object)RegexOption.IGNORE_CASE)), (CharSequence)platform, (int)0, (int)2, null) != null || StringsKt.equals((String)platform, (String)"NSMACHOperatingSystem", (boolean)true) ? "MacOS" : (StringsKt.contains((CharSequence)platform, (CharSequence)"ios", (boolean)true) ? "iOS" : (StringsKt.contains((CharSequence)platform, (CharSequence)"android", (boolean)true) ? "Android" : "Unknown (" + platform + ')'))));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lio/realm/kotlin/internal/interop/SyncConnectionParams$Runtime;", "", "description", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "JVM", "ANDROID", "NATIVE", "cinterop_release"})
    public static final class Runtime
    extends Enum<Runtime> {
        @NotNull
        private final String description;
        public static final /* enum */ Runtime JVM = new Runtime("JVM");
        public static final /* enum */ Runtime ANDROID = new Runtime("Android");
        public static final /* enum */ Runtime NATIVE = new Runtime("Native");
        private static final /* synthetic */ Runtime[] $VALUES;

        private Runtime(String description) {
            this.description = description;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public static Runtime[] values() {
            return (Runtime[])$VALUES.clone();
        }

        public static Runtime valueOf(String value) {
            return Enum.valueOf(Runtime.class, value);
        }

        static {
            $VALUES = runtimeArray = new Runtime[]{Runtime.JVM, Runtime.ANDROID, Runtime.NATIVE};
        }
    }
}

