/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.platform;

import android.os.Build;
import io.realm.kotlin.internal.RealmInitializer;
import io.realm.kotlin.internal.RealmInstantImpl;
import io.realm.kotlin.internal.interop.SyncConnectionParams;
import io.realm.kotlin.internal.platform.LogCatLogger;
import io.realm.kotlin.internal.util.Exceptions;
import io.realm.kotlin.log.RealmLogger;
import io.realm.kotlin.types.RealmInstant;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.time.Clock;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0014\u001a\u00020\u0007\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007\u001a\u0006\u0010\u001b\u001a\u00020\u001c\"\u0017\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0014\u0010\f\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\"\u0014\u0010\u000e\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\"\u0014\u0010\u0010\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\"\u0014\u0010\u0012\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u001d"}, d2={"RUNTIME", "Lio/realm/kotlin/internal/interop/SyncConnectionParams$Runtime;", "getRUNTIME$annotations", "()V", "getRUNTIME", "()Lio/realm/kotlin/internal/interop/SyncConnectionParams$Runtime;", "RUNTIME_VERSION", "", "getRUNTIME_VERSION", "()Ljava/lang/String;", "CPU_ARCH", "getCPU_ARCH", "OS_NAME", "getOS_NAME", "OS_VERSION", "getOS_VERSION", "DEVICE_MANUFACTURER", "getDEVICE_MANUFACTURER", "DEVICE_MODEL", "getDEVICE_MODEL", "appFilesDirectory", "assetFileAsStream", "Ljava/io/InputStream;", "assetFilename", "createDefaultSystemLogger", "Lio/realm/kotlin/log/RealmLogger;", "tag", "currentTime", "Lio/realm/kotlin/types/RealmInstant;", "io.realm.kotlin.library"})
public final class SystemUtilsAndroidKt {
    @NotNull
    private static final SyncConnectionParams.Runtime RUNTIME;
    @NotNull
    private static final String RUNTIME_VERSION;
    @NotNull
    private static final String CPU_ARCH;
    @NotNull
    private static final String OS_NAME;
    @NotNull
    private static final String OS_VERSION;
    @NotNull
    private static final String DEVICE_MANUFACTURER;
    @NotNull
    private static final String DEVICE_MODEL;

    @NotNull
    public static final SyncConnectionParams.Runtime getRUNTIME() {
        return RUNTIME;
    }

    public static /* synthetic */ void getRUNTIME$annotations() {
    }

    @NotNull
    public static final String getRUNTIME_VERSION() {
        return RUNTIME_VERSION;
    }

    @NotNull
    public static final String getCPU_ARCH() {
        return CPU_ARCH;
    }

    @NotNull
    public static final String getOS_NAME() {
        return OS_NAME;
    }

    @NotNull
    public static final String getOS_VERSION() {
        return OS_VERSION;
    }

    @NotNull
    public static final String getDEVICE_MANUFACTURER() {
        return DEVICE_MANUFACTURER;
    }

    @NotNull
    public static final String getDEVICE_MODEL() {
        return DEVICE_MODEL;
    }

    @NotNull
    public static final String appFilesDirectory() {
        String string = RealmInitializer.Companion.getFilesDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @NotNull
    public static final InputStream assetFileAsStream(@NotNull String assetFilename) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)assetFilename, (String)"assetFilename");
        try {
            inputStream = RealmInitializer.Companion.asset(assetFilename);
        }
        catch (FileNotFoundException e) {
            throw Exceptions.INSTANCE.assetFileNotFound(assetFilename, e);
        }
        return inputStream;
    }

    @NotNull
    public static final RealmLogger createDefaultSystemLogger(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return new LogCatLogger(tag);
    }

    @NotNull
    public static final RealmInstant currentTime() {
        RealmInstant realmInstant;
        if (Build.VERSION.SDK_INT >= 26) {
            Instant jtInstant = Clock.systemUTC().instant();
            realmInstant = new RealmInstantImpl(jtInstant.getEpochSecond(), jtInstant.getNano());
        } else {
            realmInstant = new RealmInstantImpl(System.currentTimeMillis(), 0);
        }
        return realmInstant;
    }

    static {
        String string;
        RUNTIME = SyncConnectionParams.Runtime.ANDROID;
        RUNTIME_VERSION = String.valueOf(Build.VERSION.SDK_INT);
        if (Build.VERSION.SDK_INT < 21) {
            String string2 = Build.CPU_ABI;
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            String string3 = Build.SUPPORTED_ABIS[0];
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        CPU_ARCH = string;
        OS_NAME = "Android";
        String string4 = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"RELEASE");
        OS_VERSION = string4;
        String string5 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"MANUFACTURER");
        DEVICE_MANUFACTURER = string5;
        String string6 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"MODEL");
        DEVICE_MODEL = string6;
    }
}

