/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin;

import io.realm.kotlin.CompactOnLaunchCallback;
import io.realm.kotlin.Configuration;
import io.realm.kotlin.MutableRealm;
import io.realm.kotlin.TypedRealm;
import io.realm.kotlin.internal.InternalConfiguration;
import io.realm.kotlin.internal.RealmImpl;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.NativePointerKt;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.platform.SystemUtilsKt;
import io.realm.kotlin.notifications.RealmChange;
import io.realm.kotlin.query.RealmQuery;
import io.realm.kotlin.types.TypedRealmObject;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eJK\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\b\b\u0000\u0010\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u00072\u0006\u0010\u0002\u001a\u00020\b2\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\n\"\u0004\u0018\u00010\u000bH&\u00a2\u0006\u0002\u0010\fJ-\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\u000e0\u0010\u00a2\u0006\u0002\b\u0012H\u00a6@\u00a2\u0006\u0002\u0010\u0013J,\u0010\u0014\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\u000e0\u0010\u00a2\u0006\u0002\b\u0012H&\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u00180\u0017H&J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH&J\b\u0010\u001d\u001a\u00020\u001aH&\u00a8\u0006\u001f"}, d2={"Lio/realm/kotlin/Realm;", "Lio/realm/kotlin/TypedRealm;", "query", "Lio/realm/kotlin/query/RealmQuery;", "T", "Lio/realm/kotlin/types/TypedRealmObject;", "clazz", "Lkotlin/reflect/KClass;", "", "args", "", "", "(Lkotlin/reflect/KClass;Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/kotlin/query/RealmQuery;", "write", "R", "block", "Lkotlin/Function1;", "Lio/realm/kotlin/MutableRealm;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeBlocking", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "Lio/realm/kotlin/notifications/RealmChange;", "writeCopyTo", "", "targetConfiguration", "Lio/realm/kotlin/Configuration;", "close", "Companion", "io.realm.kotlin.library"})
public interface Realm
extends TypedRealm {
    @NotNull
    public static final Companion Companion = io.realm.kotlin.Realm$Companion.$$INSTANCE;
    @NotNull
    public static final String DEFAULT_FILE_NAME = "default.realm";
    @NotNull
    public static final String DEFAULT_LOG_TAG = "REALM";
    public static final int ENCRYPTION_KEY_LENGTH = 64;

    @Override
    @NotNull
    public <T extends TypedRealmObject> RealmQuery<T> query(@NotNull KClass<T> var1, @NotNull String var2, Object ... var3);

    @Nullable
    public <R> Object write(@NotNull Function1<? super MutableRealm, ? extends R> var1, @NotNull Continuation<? super R> var2);

    public <R> R writeBlocking(@NotNull Function1<? super MutableRealm, ? extends R> var1);

    @NotNull
    public Flow<RealmChange<Realm>> asFlow();

    public void writeCopyTo(@NotNull Configuration var1);

    public void close();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\u00020\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lio/realm/kotlin/Realm$Companion;", "", "<init>", "()V", "DEFAULT_FILE_NAME", "", "DEFAULT_LOG_TAG", "ENCRYPTION_KEY_LENGTH", "", "DEFAULT_COMPACT_ON_LAUNCH_CALLBACK", "Lio/realm/kotlin/CompactOnLaunchCallback;", "getDEFAULT_COMPACT_ON_LAUNCH_CALLBACK$annotations", "getDEFAULT_COMPACT_ON_LAUNCH_CALLBACK", "()Lio/realm/kotlin/CompactOnLaunchCallback;", "open", "Lio/realm/kotlin/Realm;", "configuration", "Lio/realm/kotlin/Configuration;", "deleteRealm", "", "compactRealm", "", "io.realm.kotlin.library"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String DEFAULT_FILE_NAME = "default.realm";
        @NotNull
        public static final String DEFAULT_LOG_TAG = "REALM";
        public static final int ENCRYPTION_KEY_LENGTH = 64;
        @NotNull
        private static final CompactOnLaunchCallback DEFAULT_COMPACT_ON_LAUNCH_CALLBACK;

        private Companion() {
        }

        @NotNull
        public final CompactOnLaunchCallback getDEFAULT_COMPACT_ON_LAUNCH_CALLBACK() {
            return DEFAULT_COMPACT_ON_LAUNCH_CALLBACK;
        }

        public static /* synthetic */ void getDEFAULT_COMPACT_ON_LAUNCH_CALLBACK$annotations() {
        }

        @NotNull
        public final Realm open(@NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            return RealmImpl.Companion.create$io_realm_kotlin_library((InternalConfiguration)configuration);
        }

        public final void deleteRealm(@NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            if (!SystemUtilsKt.fileExists(configuration.getPath())) {
                return;
            }
            RealmInterop.INSTANCE.realm_delete_files(configuration.getPath());
        }

        public final boolean compactRealm(@NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            if (SystemUtilsKt.isWindows()) {
                throw new NotImplementedError("Realm.compact() is not supported on Windows. See https://github.com/realm/realm-core/issues/4111 for more information.");
            }
            if (!SystemUtilsKt.fileExists(configuration.getPath())) {
                return false;
            }
            InternalConfiguration config = (InternalConfiguration)configuration;
            return (Boolean)NativePointerKt.use((NativePointer)RealmInterop.INSTANCE.realm_create_scheduler(), arg_0 -> Companion.compactRealm$lambda$1(config, arg_0));
        }

        private static final boolean DEFAULT_COMPACT_ON_LAUNCH_CALLBACK$lambda$0(long totalBytes, long usedBytes) {
            long thresholdSize = 0x3200000L;
            return totalBytes > thresholdSize && (double)usedBytes / (double)totalBytes <= 0.5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final boolean compactRealm$lambda$1(InternalConfiguration $config, NativePointer scheduler2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
            Intrinsics.checkNotNullParameter((Object)scheduler2, (String)"scheduler");
            NativePointer dbPointer = (NativePointer)RealmInterop.INSTANCE.realm_open($config.createNativeConfiguration(), scheduler2).component1();
            try {
                bl = RealmInterop.INSTANCE.realm_compact(dbPointer);
            }
            finally {
                RealmInterop.INSTANCE.realm_close(dbPointer);
            }
            return bl;
        }

        static {
            $$INSTANCE = new Companion();
            DEFAULT_COMPACT_ON_LAUNCH_CALLBACK = Companion::DEFAULT_COMPACT_ON_LAUNCH_CALLBACK$lambda$0;
        }
    }
}

