/*
 * Decompiled with CFR 0.152.
 */
package io.silverware.microservices;

import io.silverware.microservices.MicroserviceMetaData;
import io.silverware.microservices.providers.MicroserviceProvider;
import io.silverware.microservices.silver.ProvidingSilverService;
import io.silverware.microservices.silver.SilverService;
import io.silverware.microservices.silver.cluster.ServiceHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Context {
    private static final Logger log = LogManager.getLogger(Context.class);
    public static final String MICROSERVICE_PROVIDERS_REGISTRY = "silverware.providers.registry";
    public static final String DEPLOYMENT_PACKAGES = "silverware.deploy.packages";
    public static final String MICROSERVICES = "silverware.microservices";
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, MicroserviceProvider> providers = new HashMap<String, MicroserviceProvider>();
    private final Set<MicroserviceMetaData> microservices = new HashSet<MicroserviceMetaData>();
    private List<ServiceHandle> inboundHandles = new ArrayList<ServiceHandle>();

    public Context() {
        this.properties.put(MICROSERVICE_PROVIDERS_REGISTRY, this.providers);
        this.properties.put(MICROSERVICES, this.microservices);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, MicroserviceProvider> getProvidersRegistry() {
        return (Map)this.properties.get(MICROSERVICE_PROVIDERS_REGISTRY);
    }

    public void registerMicroservice(MicroserviceMetaData metaData) {
        this.microservices.add(metaData);
    }

    public Set<MicroserviceMetaData> getMicroservices() {
        return Collections.unmodifiableSet(this.microservices);
    }

    public Set<Object> lookupMicroservice(MicroserviceMetaData metaData) {
        HashSet<Object> microservices = new HashSet<Object>();
        this.getAllProviders(ProvidingSilverService.class).forEach(provider -> microservices.addAll(((ProvidingSilverService)provider).lookupMicroservice(metaData)));
        return microservices;
    }

    public Set<Object> lookupLocalMicroservice(MicroserviceMetaData metaData) {
        HashSet<Object> microservices = new HashSet<Object>();
        this.getAllProviders(ProvidingSilverService.class).forEach(provider -> microservices.addAll(((ProvidingSilverService)provider).lookupLocalMicroservice(metaData)));
        return microservices;
    }

    public SilverService getProvider(Class<? extends SilverService> clazz) {
        for (Map.Entry<String, MicroserviceProvider> entry : this.providers.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getValue().getClass())) continue;
            return (SilverService)((Object)entry.getValue());
        }
        return null;
    }

    public Set<SilverService> getAllProviders(Class<? extends SilverService> clazz) {
        return this.providers.entrySet().stream().filter(entry -> clazz.isAssignableFrom(((MicroserviceProvider)entry.getValue()).getClass())).map(entry -> (SilverService)entry.getValue()).collect(Collectors.toSet());
    }

    public List<ServiceHandle> assureHandles(MicroserviceMetaData metaData) {
        List<ServiceHandle> result = this.inboundHandles.stream().filter(serviceHandle -> serviceHandle.getQuery().equals(metaData)).collect(Collectors.toList());
        Set<Object> microservices = this.lookupLocalMicroservice(metaData);
        Set haveHandles = result.stream().map(ServiceHandle::getService).collect(Collectors.toSet());
        microservices.removeAll(haveHandles);
        microservices.forEach(microservice -> {
            String host = this.properties.get("silverware.http.address") + ":" + this.properties.get("silverware.http.port");
            ServiceHandle handle = new ServiceHandle(host, metaData, microservice);
            result.add(handle);
            this.inboundHandles.add(handle);
        });
        return result;
    }

    public ServiceHandle getInboundServiceHandle(int handle) {
        return this.inboundHandles.stream().filter(serviceHandle -> serviceHandle.getHandle() == handle).findFirst().get();
    }
}

