/*
 * Decompiled with CFR 0.152.
 */
package io.silverware.microservices.silver.cluster;

import io.silverware.microservices.Context;
import io.silverware.microservices.SilverWareException;
import io.silverware.microservices.silver.cluster.ServiceHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Invocation {
    private static Logger log = LogManager.getLogger(Invocation.class);
    private final int handle;
    private final String method;
    private final Class[] paramTypes;
    private final Object[] params;

    public Invocation(int handle, String method, Class[] paramTypes, Object[] params) {
        this.handle = handle;
        this.method = method;
        this.paramTypes = paramTypes;
        this.params = params;
    }

    public int getHandle() {
        return this.handle;
    }

    public String getMethod() {
        return this.method;
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public Object[] getParams() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invocation that = (Invocation)o;
        if (this.handle != that.handle) {
            return false;
        }
        if (!this.method.equals(that.method)) {
            return false;
        }
        if (!Arrays.equals(this.paramTypes, that.paramTypes)) {
            return false;
        }
        return Arrays.equals(this.params, that.params);
    }

    public int hashCode() {
        int result = this.handle;
        result = 31 * result + this.method.hashCode();
        result = 31 * result + Arrays.hashCode(this.paramTypes);
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    public String toString() {
        return "Invocation{handle=" + this.handle + ", method='" + this.method + '\'' + ", paramTypes=" + Arrays.toString(this.paramTypes) + ", params=" + Arrays.toString(this.params) + '}';
    }

    public Object invoke(Context context) throws Exception {
        ServiceHandle serviceHandle;
        if (log.isTraceEnabled()) {
            log.trace("Invoking Microservice with invocation {}.", new Object[]{this.toString()});
        }
        if ((serviceHandle = context.getInboundServiceHandle(this.handle)) == null) {
            throw new SilverWareException(String.format("Handle no. %d. No such handle found.", this.getHandle()));
        }
        Method method = serviceHandle.getService().getClass().getDeclaredMethod(this.getMethod(), this.paramTypes);
        return method.invoke(serviceHandle.getService(), this.params);
    }
}

