/*
 * Decompiled with CFR 0.152.
 */
package io.silverware.microservices.silver.http;

import java.util.Properties;

public class ServletDescriptor {
    private final String name;
    private final Class<?> servletClass;
    private final String mapping;
    private final Properties properties;

    public ServletDescriptor(String name, Class<?> servletClass, String mapping, Properties properties) {
        this.name = name;
        this.servletClass = servletClass;
        this.mapping = mapping;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getServletClass() {
        return this.servletClass;
    }

    public String getMapping() {
        return this.mapping;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServletDescriptor that = (ServletDescriptor)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.servletClass.equals(that.servletClass)) {
            return false;
        }
        if (!this.mapping.equals(that.mapping)) {
            return false;
        }
        return !(this.properties == null ? that.properties != null : !this.properties.equals(that.properties));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.servletClass.hashCode();
        result = 31 * result + this.mapping.hashCode();
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServletDescriptor{name='" + this.name + '\'' + ", servletClass=" + this.servletClass + ", mapping='" + this.mapping + '\'' + ", properties=" + this.properties + '}';
    }
}

