/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement;

import io.spring.gradle.dependencymanagement.dsl.DependencyManagementExtension;
import io.spring.gradle.dependencymanagement.internal.bridge.InternalComponents;
import io.spring.gradle.dependencymanagement.maven.PomDependencyManagementConfigurer;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;

public class DependencyManagementPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        InternalComponents internalComponents = new InternalComponents(project);
        DependencyManagementExtension dependencyManagementExtension = internalComponents.getDependencyManagementExtension();
        project.getExtensions().add("dependencyManagement", (Object)dependencyManagementExtension);
        internalComponents.createDependencyManagementReportTask("dependencyManagement");
        project.getConfigurations().all(internalComponents.getImplicitDependencyManagementCollector());
        project.getConfigurations().all(internalComponents.getDependencyManagementApplier());
        this.configurePomCustomization(project, dependencyManagementExtension);
    }

    private void configurePomCustomization(Project project, DependencyManagementExtension dependencyManagementExtension) {
        PomDependencyManagementConfigurer pomConfigurer = dependencyManagementExtension.getPomConfigurer();
        project.getPlugins().withType(MavenPublishPlugin.class, mavenPublishPlugin -> this.configurePublishingExtension(project, pomConfigurer));
    }

    private void configurePublishingExtension(Project project, PomDependencyManagementConfigurer extension) {
        project.getExtensions().configure(PublishingExtension.class, publishingExtension -> this.configurePublications((PublishingExtension)publishingExtension, extension));
    }

    private void configurePublications(PublishingExtension publishingExtension, PomDependencyManagementConfigurer extension) {
        publishingExtension.getPublications().withType(MavenPublication.class, mavenPublication -> mavenPublication.getPom().withXml((Action)extension));
    }
}

