/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.eclipse.sisu.space;

import java.util.regex.Pattern;

enum GlobberStrategy {
    ANYTHING{

        @Override
        final Object compile(String glob) {
            return null;
        }

        @Override
        final boolean matches(Object globPattern, String filename) {
            return true;
        }
    }
    ,
    SUFFIX{

        @Override
        final Object compile(String glob) {
            return glob.substring(1);
        }

        @Override
        final boolean matches(Object globPattern, String filename) {
            return filename.endsWith((String)globPattern);
        }
    }
    ,
    PREFIX{

        @Override
        final Object compile(String glob) {
            return glob.substring(0, glob.length() - 1);
        }

        @Override
        final boolean matches(Object globPattern, String filename) {
            return 3.basename(filename).startsWith((String)globPattern);
        }
    }
    ,
    EXACT{

        @Override
        final Object compile(String glob) {
            return glob;
        }

        @Override
        final boolean matches(Object globPattern, String filename) {
            return globPattern.equals(4.basename(filename));
        }
    }
    ,
    PATTERN{

        @Override
        final Object compile(String glob) {
            return Pattern.compile("\\Q" + glob.replaceAll("\\*+", "\\\\E.*\\\\Q") + "\\E");
        }

        @Override
        final boolean matches(Object globPattern, String filename) {
            return ((Pattern)globPattern).matcher(5.basename(filename)).matches();
        }
    };


    private GlobberStrategy() {
    }

    static final GlobberStrategy selectFor(String glob) {
        if (glob == null || "*".equals(glob)) {
            return ANYTHING;
        }
        int firstWildcard = glob.indexOf(42);
        if (firstWildcard < 0) {
            return EXACT;
        }
        int lastWildcard = glob.lastIndexOf(42);
        if (firstWildcard == lastWildcard) {
            if (firstWildcard == 0) {
                return SUFFIX;
            }
            if (lastWildcard == glob.length() - 1) {
                return PREFIX;
            }
        }
        return PATTERN;
    }

    abstract Object compile(String var1);

    abstract boolean matches(Object var1, String var2);

    static final String basename(String filename) {
        return filename.substring(1 + filename.lastIndexOf(47));
    }

    /* synthetic */ GlobberStrategy(String string, int n, GlobberStrategy globberStrategy) {
        this();
    }
}

