/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import javax.validation.constraints.NotNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.BeanValidators;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class NotNullAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ModelPropertyContext context) {
        Optional<NotNull> notNull = this.extractAnnotation(context);
        context.getBuilder().required(Boolean.valueOf(notNull.isPresent()));
    }

    @VisibleForTesting
    Optional<NotNull> extractAnnotation(ModelPropertyContext context) {
        return BeanValidators.validatorFromBean(context, NotNull.class).or(BeanValidators.validatorFromField(context, NotNull.class));
    }
}

