/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import springfox.documentation.service.ServerVariable;
import springfox.documentation.service.VendorExtension;

public class Server {
    private final String name;
    private final String url;
    private final String description;
    private final Map<String, ServerVariable> variables = new HashMap<String, ServerVariable>();
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();

    public Server(String name, String url, String description, Collection<ServerVariable> variables, List<VendorExtension> extensions) {
        this.name = name;
        this.url = url;
        this.description = description;
        variables.forEach(v -> this.variables.put(v.getName(), (ServerVariable)v));
        this.extensions.addAll(extensions);
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<ServerVariable> getVariables() {
        return this.variables.values();
    }

    public Collection<VendorExtension> getExtensions() {
        return this.extensions;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Server server = (Server)o;
        return Objects.equals(this.name, server.name) && Objects.equals(this.url, server.url) && Objects.equals(this.description, server.description) && Objects.equals(this.variables, server.variables) && Objects.equals(this.extensions, server.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.description, this.variables, this.extensions);
    }

    public String toString() {
        return new StringJoiner(", ", Server.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("url='" + this.url + "'").add("description='" + this.description + "'").add("variables=" + this.variables).add("extensions=" + this.extensions).toString();
    }
}

