/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="cachedModelProperties")
public class CachingModelPropertiesProvider
implements ModelPropertiesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingModelPropertiesProvider.class);
    private final Map<ModelContext, List<ModelProperty>> cache = new HashMap<ModelContext, List<ModelProperty>>();
    private final Function<ModelContext, List<ModelProperty>> lookup = key -> delegate.propertiesFor(key.resolvedType(resolver), (ModelContext)key);

    @Autowired
    public CachingModelPropertiesProvider(TypeResolver resolver, @Qualifier(value="optimized") ModelPropertiesProvider delegate) {
    }

    @Override
    public List<ModelProperty> propertiesFor(ResolvedType type, ModelContext givenContext) {
        try {
            return this.cache.computeIfAbsent(givenContext, this.lookup);
        }
        catch (Exception e) {
            LOGGER.warn("Exception calculating properties for model({}) -> {}. {}", new Object[]{type, givenContext.description(), e.getMessage()});
            return new ArrayList<ModelProperty>();
        }
    }

    public void onApplicationEvent(ObjectMapperConfigured event) {
    }
}

