/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="cachedModelProperties")
public class CachingModelPropertiesProvider
implements ModelPropertiesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingModelPropertiesProvider.class);
    private final LoadingCache<ModelContext, List<ModelProperty>> cache;

    @Autowired
    public CachingModelPropertiesProvider(final TypeResolver resolver, final @Qualifier(value="optimized") ModelPropertiesProvider delegate) {
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<ModelContext, List<ModelProperty>>(){

            public List<ModelProperty> load(ModelContext key) {
                return delegate.propertiesFor(key.resolvedType(resolver), key);
            }
        });
    }

    @Override
    public List<ModelProperty> propertiesFor(ResolvedType type, ModelContext givenContext) {
        try {
            return (List)this.cache.get((Object)givenContext);
        }
        catch (Exception e) {
            LOGGER.warn("Exception calculating properties for model({}) -> {}. {}", new Object[]{type, givenContext.description(), e.getMessage()});
            return Lists.newArrayList();
        }
    }

    public void onApplicationEvent(ObjectMapperConfigured event) {
    }
}

