/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483648)
public class MediaTypeReader
implements OperationBuilderPlugin,
ApiListingBuilderPlugin {
    public void apply(OperationContext context) {
        DocumentationContext documentationContext = context.getDocumentationContext();
        Set<String> operationConsumesList = this.toSet(context.consumes());
        Set<String> operationProducesList = this.toSet(context.produces());
        if (this.handlerMethodHasFileParameter(context)) {
            operationConsumesList = Collections.singleton("multipart/form-data");
        }
        if (operationProducesList.isEmpty() && documentationContext.getProduces().isEmpty()) {
            operationProducesList.add("*/*");
        }
        if (operationConsumesList.isEmpty() && documentationContext.getConsumes().isEmpty()) {
            operationConsumesList.add("application/json");
        }
        context.operationBuilder().consumes(operationConsumesList);
        context.operationBuilder().produces(operationProducesList);
    }

    public void apply(ApiListingContext context) {
        RequestMapping annotation;
        Optional controller = context.getResourceGroup().getControllerClass();
        if (controller.isPresent() && (annotation = (RequestMapping)AnnotationUtils.findAnnotation((Class)((Class)controller.get()), RequestMapping.class)) != null) {
            context.apiListingBuilder().appendProduces(Stream.of(annotation.produces()).collect(Collectors.toList())).appendConsumes(Stream.of(annotation.consumes()).collect(Collectors.toList()));
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private boolean handlerMethodHasFileParameter(OperationContext context) {
        List methodParameters = context.getParameters();
        for (ResolvedMethodParameter resolvedMethodParameter : methodParameters) {
            if (!MultipartFile.class.isAssignableFrom(resolvedMethodParameter.getParameterType().getErasedType())) continue;
            return true;
        }
        return false;
    }

    private Set<String> toSet(Set<? extends MediaType> mediaTypeSet) {
        HashSet<String> mediaTypes = new HashSet<String>();
        for (MediaType mediaType : mediaTypeSet) {
            mediaTypes.add(mediaType.toString());
        }
        return mediaTypes;
    }
}

