/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Component;
import springfox.documentation.RequestHandler;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.DocumentationPlugin;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spi.service.contexts.Defaults;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.DocumentationContextBuilder;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.plugins.DefaultConfiguration;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.scanners.ApiDocumentationScanner;

@Component
public class DocumentationPluginsBootstrapper
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(DocumentationPluginsBootstrapper.class);
    private final DocumentationPluginsManager documentationPluginsManager;
    private final List<RequestHandlerProvider> handlerProviders;
    private final DocumentationCache scanned;
    private final ApiDocumentationScanner resourceListing;
    private final DefaultConfiguration defaultConfiguration;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    @Autowired
    public DocumentationPluginsBootstrapper(DocumentationPluginsManager documentationPluginsManager, List<RequestHandlerProvider> handlerProviders, DocumentationCache scanned, ApiDocumentationScanner resourceListing, TypeResolver typeResolver, Defaults defaults, ServletContext servletContext) {
        this.documentationPluginsManager = documentationPluginsManager;
        this.handlerProviders = handlerProviders;
        this.scanned = scanned;
        this.resourceListing = resourceListing;
        this.defaultConfiguration = new DefaultConfiguration(defaults, typeResolver, servletContext);
    }

    private DocumentationContext buildContext(DocumentationPlugin each) {
        return each.configure(this.defaultContextBuilder(each));
    }

    private void scanDocumentation(DocumentationContext context) {
        this.scanned.addDocumentation(this.resourceListing.scan(context));
    }

    private DocumentationContextBuilder defaultContextBuilder(DocumentationPlugin each) {
        DocumentationType documentationType = each.getDocumentationType();
        ImmutableList requestHandlers = FluentIterable.from(this.handlerProviders).transformAndConcat(this.handlers()).toList();
        return this.documentationPluginsManager.createContextBuilder(documentationType, this.defaultConfiguration).requestHandlers((List)requestHandlers);
    }

    private Function<RequestHandlerProvider, ? extends Iterable<RequestHandler>> handlers() {
        return new Function<RequestHandlerProvider, Iterable<RequestHandler>>(){

            public Iterable<RequestHandler> apply(RequestHandlerProvider input) {
                return input.requestHandlers();
            }
        };
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        callback.run();
    }

    public void start() {
        if (this.initialized.compareAndSet(false, true)) {
            log.info("Context refreshed");
            List plugins = Orderings.pluginOrdering().sortedCopy(this.documentationPluginsManager.documentationPlugins());
            log.info("Found {} custom documentation plugin(s)", (Object)plugins.size());
            for (DocumentationPlugin each : plugins) {
                DocumentationType documentationType = each.getDocumentationType();
                if (each.isEnabled()) {
                    this.scanDocumentation(this.buildContext(each));
                    continue;
                }
                log.info("Skipping initializing disabled plugin bean {} v{}", (Object)documentationType.getName(), (Object)documentationType.getVersion());
            }
        }
    }

    public void stop() {
        this.initialized.getAndSet(false);
        this.scanned.clear();
    }

    public boolean isRunning() {
        return this.initialized.get();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }
}

