/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import io.swagger.annotations.Api;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ResourceGroupingStrategy;
import springfox.documentation.spring.web.paths.Paths;
import springfox.documentation.spring.wrapper.RequestMappingInfo;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Deprecated
public class ClassOrApiAnnotationResourceGrouping
implements ResourceGroupingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ClassOrApiAnnotationResourceGrouping.class);

    public String getResourceDescription(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        Class controllerClass = handlerMethod.getBeanType();
        String className = Paths.splitCamelCase((String)controllerClass.getSimpleName(), (String)" ");
        return Paths.stripSlashes((String)this.extractAnnotation(controllerClass, this.descriptionOrValueExtractor()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(className));
    }

    public Integer getResourcePosition(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        Class controllerClass = handlerMethod.getBeanType();
        Api apiAnnotation = (Api)AnnotationUtils.findAnnotation((Class)controllerClass, Api.class);
        if (null != apiAnnotation && StringUtils.hasText((String)apiAnnotation.value())) {
            return apiAnnotation.position();
        }
        return 0;
    }

    public Set<ResourceGroup> getResourceGroups(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return this.groups(handlerMethod).stream().map(this.toResourceGroup(requestMappingInfo, handlerMethod)).collect(Collectors.toSet());
    }

    private Set<String> groups(HandlerMethod handlerMethod) {
        Class controllerClass = handlerMethod.getBeanType();
        String group = Paths.splitCamelCase((String)controllerClass.getSimpleName(), (String)" ");
        String apiValue = Optional.ofNullable(AnnotationUtils.findAnnotation((Class)controllerClass, Api.class)).map(this.toApiValue()).orElse("");
        return Collections.singleton(this.normalize(Optional.ofNullable(apiValue).filter(((Predicate<String>)String::isEmpty).negate()).orElse(group)));
    }

    private String normalize(String tag) {
        return tag.toLowerCase().replaceAll(" ", "-").replaceAll("/", "");
    }

    private Function<String, ResourceGroup> toResourceGroup(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return group -> {
            LOG.info("Group for method {} was {}", (Object)handlerMethod.getMethod().getName(), group);
            Integer position = this.getResourcePosition(requestMappingInfo, handlerMethod);
            return new ResourceGroup(group, handlerMethod.getBeanType(), position);
        };
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private <T> T extractAnnotation(Class<?> controllerClass, Function<Api, T> annotationExtractor) {
        Api apiAnnotation = (Api)AnnotationUtils.findAnnotation(controllerClass, Api.class);
        return annotationExtractor.apply(apiAnnotation);
    }

    private Function<Api, Optional<String>> descriptionOrValueExtractor() {
        return input -> this.descriptionExtractor().apply((Api)input).map(Optional::of).orElse(this.valueExtractor().apply((Api)input));
    }

    private Function<Api, String> toApiValue() {
        return input -> this.normalize(input.value());
    }

    private Function<Api, Optional<String>> descriptionExtractor() {
        return input -> {
            if (null != input) {
                return Optional.of(input.description()).filter(((Predicate<String>)String::isEmpty).negate());
            }
            return Optional.empty();
        };
    }

    private Function<Api, Optional<String>> valueExtractor() {
        return input -> {
            if (null != input) {
                return Optional.of(input.value()).filter(((Predicate<String>)String::isEmpty).negate());
            }
            return Optional.empty();
        };
    }
}

