/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal;

import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeRef;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class BuildableRepository {
    private final Map<String, TypeDef> buildables = new HashMap<String, TypeDef>();

    public TypeDef register(TypeDef buildable) {
        if (buildable != null) {
            this.buildables.put(buildable.getFullyQualifiedName(), buildable);
        }
        return buildable;
    }

    public Set<TypeDef> getBuildables() {
        return Collections.unmodifiableSet(new LinkedHashSet<TypeDef>(this.buildables.values()));
    }

    public TypeDef getBuildable(TypeRef type) {
        if (type instanceof ClassRef) {
            return this.buildables.get(((ClassRef)type).getDefinition().getFullyQualifiedName());
        }
        return null;
    }

    public boolean isBuildable(TypeDef type) {
        return type != null && this.buildables.containsKey(type.getFullyQualifiedName());
    }

    public boolean isBuildable(TypeRef type) {
        if (type instanceof ClassRef) {
            return this.isBuildable(((ClassRef)type).getDefinition());
        }
        return false;
    }

    public void clear() {
        this.buildables.clear();
    }
}

