/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.processor;

import io.sundr.builder.annotations.ExternalBuildables;
import io.sundr.builder.annotations.Inline;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.ClazzAs;
import io.sundr.builder.internal.processor.AbstractBuilderProcessor;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.functions.ElementTo;
import io.sundr.codegen.model.EditableTypeDef;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.utils.ModelUtils;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.sundr.builder.annotations.ExternalBuildables"})
public class ExternalBuildableProcessor
extends AbstractBuilderProcessor {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        ExternalBuildables generated;
        Elements elements = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        Filer filer = this.processingEnv.getFiler();
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                generated = element.getAnnotation(ExternalBuildables.class);
                BuilderContext ctx = BuilderContextManager.create(elements, types, generated.generateBuilderPackage(), generated.builderPackage(), new Inline[0]);
                for (String name : generated.value()) {
                    TypeElement typeElement2 = elements.getTypeElement(name);
                    TypeDef b = ctx.getBuildableRepository().register((TypeDef)ElementTo.TYPEDEF.apply((Object)typeElement2));
                    ctx.getDefinitionRepository().register(b);
                    ctx.getBuildableRepository().register(b);
                }
                for (TypeElement ref : BuilderUtils.getBuildableReferences(ctx, generated)) {
                    TypeDef b = (TypeDef)ElementTo.TYPEDEF.apply((Object)ModelUtils.getClassElement((Element)ref));
                    ctx.getDefinitionRepository().register(b);
                    ctx.getBuildableRepository().register(b);
                }
            }
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                generated = element.getAnnotation(ExternalBuildables.class);
                for (String name : generated.value()) {
                    TypeElement typeElement3 = elements.getTypeElement(name);
                    if (typeElement3 == null) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Type:" + name + " doesn't exists. Ignoring...");
                        continue;
                    }
                    BuilderContext ctx = BuilderContextManager.getContext();
                    EditableTypeDef typeDef = ((TypeDefBuilder)new TypeDefBuilder((TypeDef)ElementTo.TYPEDEF.apply((Object)ModelUtils.getClassElement((Element)element))).addToAttributes("VALIDATION_ENABLED", (Object)generated.validationEnabled())).build();
                    this.generateLocalDependenciesIfNeeded();
                    try {
                        this.generateFromClazz((TypeDef)ClazzAs.FLUENT_INTERFACE.apply((Object)typeDef), "templates/builder/sourcefile.vm");
                        if (generated.editableEnabled()) {
                            this.generateFromClazz((TypeDef)ClazzAs.EDITABLE_BUILDER.apply((Object)typeDef), "templates/builder/sourcefile.vm");
                            this.generateFromClazz((TypeDef)ClazzAs.EDITABLE.apply((Object)typeDef), "templates/builder/sourcefile.vm");
                        } else {
                            this.generateFromClazz((TypeDef)ClazzAs.BUILDER.apply((Object)typeDef), "templates/builder/sourcefile.vm");
                        }
                        for (Inline inline : generated.inline()) {
                            this.generateFromClazz(ExternalBuildableProcessor.inlineableOf(ctx, (TypeDef)typeDef, inline), "templates/builder/sourcefile.vm");
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return true;
    }
}

