/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.utils;

import io.sundr.SundrException;
import io.sundr.builder.Constants;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.ExternalBuildables;
import io.sundr.builder.annotations.Inline;
import io.sundr.builder.internal.BuildableRepository;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.CollectionTypes;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.codegen.DefinitionRepository;
import io.sundr.codegen.functions.ClassTo;
import io.sundr.codegen.functions.ElementTo;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.Method;
import io.sundr.codegen.model.PrimitiveRef;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeParamDef;
import io.sundr.codegen.model.TypeParamDefBuilder;
import io.sundr.codegen.model.TypeParamRef;
import io.sundr.codegen.model.TypeRef;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;

public class BuilderUtils {
    public static final String BUILDABLE = "BUILDABLE";
    private static final String[] GENERIC_NAMES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S"};

    private BuilderUtils() {
    }

    public static boolean isBuildable(TypeRef typeRef) {
        BuildableRepository repository = BuilderContextManager.getContext().getBuildableRepository();
        return repository.isBuildable(typeRef);
    }

    public static boolean isBuildable(TypeDef typeDef) {
        BuildableRepository repository = BuilderContextManager.getContext().getBuildableRepository();
        return repository.isBuildable(typeDef);
    }

    public static ClassRef findBuildableSuperClassRef(TypeDef clazz) {
        BuildableRepository repository = BuilderContextManager.getContext().getBuildableRepository();
        for (ClassRef superClass : clazz.getExtendsList()) {
            if (!repository.isBuildable((TypeRef)superClass)) continue;
            return superClass;
        }
        return null;
    }

    public static TypeDef findBuildableSuperClass(TypeDef clazz) {
        BuildableRepository repository = BuilderContextManager.getContext().getBuildableRepository();
        for (ClassRef superClass : clazz.getExtendsList()) {
            if (!repository.isBuildable((TypeRef)superClass)) continue;
            return repository.getBuildable((TypeRef)superClass);
        }
        return null;
    }

    public static Method findBuildableConstructor(TypeDef clazz) {
        for (Method candidate : clazz.getConstructors()) {
            if (!candidate.getAnnotations().contains(Constants.BUILDABLE_ANNOTATION_REF)) continue;
            return candidate;
        }
        for (Method candidate : clazz.getConstructors()) {
            if (candidate.getArguments().size() == 0) continue;
            return candidate;
        }
        if (!clazz.getConstructors().isEmpty()) {
            return (Method)clazz.getConstructors().iterator().next();
        }
        throw new IllegalStateException("Could not find buildable constructor in: [" + clazz.getFullyQualifiedName() + "].");
    }

    public static Method findGetter(TypeDef clazz, Property property) {
        TypeDef current = clazz;
        while (current != null && !current.equals((Object)TypeDef.OBJECT)) {
            for (Method method : current.getMethods()) {
                if (!BuilderUtils.isApplicableGetterOf(method, property)) continue;
                return method;
            }
            if (!current.getExtendsList().iterator().hasNext()) break;
            String fqn = ((ClassRef)current.getExtendsList().iterator().next()).getDefinition().getFullyQualifiedName();
            current = DefinitionRepository.getRepository().getDefinition(fqn);
        }
        throw new SundrException("No getter found for property: " + property.getName() + " on class: " + clazz.getFullyQualifiedName());
    }

    public static boolean hasSetter(TypeDef clazz, Property property) {
        for (Method method : clazz.getMethods()) {
            if (!BuilderUtils.isApplicableSetterOf(method, property)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOrInheritsSetter(TypeDef clazz, Property property) {
        TypeDef current = clazz;
        while (current != null && !current.equals((Object)TypeDef.OBJECT)) {
            for (Method method : current.getMethods()) {
                if (!BuilderUtils.isApplicableSetterOf(method, property)) continue;
                return true;
            }
            if (!current.getExtendsList().isEmpty()) {
                String fqn = ((ClassRef)current.getExtendsList().iterator().next()).getDefinition().getFullyQualifiedName();
                current = DefinitionRepository.getRepository().getDefinition(fqn);
                continue;
            }
            current = null;
        }
        return false;
    }

    private static boolean isApplicableGetterOf(Method method, Property property) {
        if (!method.getReturnType().isAssignableFrom(property.getTypeRef())) {
            return false;
        }
        if (method.getName().endsWith("get" + property.getNameCapitalized())) {
            return true;
        }
        return method.getName().endsWith("is" + property.getNameCapitalized());
    }

    private static boolean isApplicableSetterOf(Method method, Property property) {
        if (method.getArguments().size() != 1) {
            return false;
        }
        if (!((Property)method.getArguments().get(0)).getTypeRef().equals(property.getTypeRef())) {
            return false;
        }
        return method.getName().endsWith("set" + property.getNameCapitalized());
    }

    public static boolean methodHasArgument(Method method, Property property) {
        for (Property candidate : method.getArguments()) {
            if (!candidate.equals((Object)property)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBuildableConstructorWithArgument(TypeDef clazz, Property property) {
        Method constructor = BuilderUtils.findBuildableConstructor(clazz);
        if (constructor == null) {
            return false;
        }
        return BuilderUtils.methodHasArgument(constructor, property);
    }

    public static boolean hasDefaultConstructor(TypeDef item) {
        if (item == null) {
            return false;
        }
        if (item.getConstructors().isEmpty()) {
            return true;
        }
        for (Method constructor : item.getConstructors()) {
            if (constructor.getArguments().size() != 0) continue;
            return true;
        }
        return false;
    }

    public static Set<Method> getInlineableConstructors(Property property) {
        TypeDef fromRepo;
        HashSet<Method> result = new HashSet<Method>();
        TypeRef unwrapped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)property.getTypeRef());
        if (unwrapped instanceof ClassRef) {
            for (Method candidate : ((ClassRef)unwrapped).getDefinition().getConstructors()) {
                if (!BuilderUtils.isInlineable(candidate)) continue;
                result.add(candidate);
            }
        }
        if ((fromRepo = BuilderContextManager.getContext().getDefinitionRepository().getDefinition(unwrapped)) != null) {
            for (Method candidate : fromRepo.getConstructors()) {
                if (!BuilderUtils.isInlineable(candidate)) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    public static boolean isInlineable(Method method) {
        if (method.getArguments().size() == 0 || method.getArguments().size() > 5) {
            return false;
        }
        for (Property argument : method.getArguments()) {
            if (!(argument.getTypeRef() instanceof ClassRef) || ((ClassRef)argument.getTypeRef()).getDefinition().getFullyQualifiedName().startsWith("java.lang")) continue;
            return false;
        }
        return true;
    }

    public static TypeDef getInlineType(BuilderContext context, Inline inline) {
        try {
            return (TypeDef)ClassTo.TYPEDEF.apply((Object)inline.type());
        }
        catch (MirroredTypeException e) {
            Element element = context.getTypes().asElement(e.getTypeMirror());
            return (TypeDef)ElementTo.TYPEDEF.apply((Object)((TypeElement)element));
        }
    }

    public static TypeDef getInlineReturnType(BuilderContext context, Inline inline, TypeDef fallback) {
        try {
            Class returnType = inline.returnType();
            if (returnType == null) {
                return fallback;
            }
            return (TypeDef)ClassTo.TYPEDEF.apply((Object)inline.returnType());
        }
        catch (MirroredTypeException e) {
            if ("io.sundr.builder.annotations.None".equals(e.getTypeMirror().toString())) {
                return fallback;
            }
            Element element = context.getTypes().asElement(e.getTypeMirror());
            return (TypeDef)ElementTo.TYPEDEF.apply((Object)((TypeElement)element));
        }
    }

    public static Set<TypeElement> getBuildableReferences(BuilderContext context, Buildable buildable) {
        LinkedHashSet<TypeElement> result = new LinkedHashSet<TypeElement>();
        for (BuildableReference ref : buildable.refs()) {
            try {
                result.add(context.getElements().getTypeElement(ref.value().getCanonicalName()));
            }
            catch (MirroredTypeException e) {
                result.add(context.getElements().getTypeElement(e.getTypeMirror().toString()));
            }
        }
        return result;
    }

    public static Set<TypeElement> getBuildableReferences(BuilderContext context, ExternalBuildables buildable) {
        LinkedHashSet<TypeElement> result = new LinkedHashSet<TypeElement>();
        for (BuildableReference ref : buildable.refs()) {
            try {
                result.add(context.getElements().getTypeElement(ref.value().getCanonicalName()));
            }
            catch (MirroredTypeException e) {
                result.add(context.getElements().getTypeElement(e.getTypeMirror().toString()));
            }
        }
        return result;
    }

    public static boolean isPrimitive(TypeRef type) {
        return type instanceof PrimitiveRef;
    }

    public static boolean isMap(TypeRef type) {
        return (Boolean)CollectionTypes.IS_MAP.apply((Object)type);
    }

    public static boolean isList(TypeRef type) {
        return (Boolean)CollectionTypes.IS_LIST.apply((Object)type);
    }

    public static boolean isSet(TypeRef type) {
        return (Boolean)CollectionTypes.IS_SET.apply((Object)type);
    }

    public static boolean isCollection(TypeRef type) {
        return (Boolean)CollectionTypes.IS_COLLECTION.apply((Object)type);
    }

    public static boolean isBoolean(TypeRef type) {
        if (type instanceof PrimitiveRef) {
            return ((PrimitiveRef)type).getName().equals("boolean");
        }
        if (!(type instanceof ClassRef)) {
            return false;
        }
        return ((ClassRef)type).getDefinition().equals((Object)Constants.BOOLEAN);
    }

    public static boolean isArray(TypeRef type) {
        if (type instanceof ClassRef) {
            return ((ClassRef)type).getDimensions() > 0;
        }
        if (type instanceof PrimitiveRef) {
            return ((PrimitiveRef)type).getDimensions() > 0;
        }
        if (type instanceof TypeParamRef) {
            return ((TypeParamRef)type).getDimensions() > 0;
        }
        return false;
    }

    public static TypeParamDef getNextGeneric(TypeDef type, TypeParamDef ... excluded) {
        return BuilderUtils.getNextGeneric(type, Arrays.asList(excluded));
    }

    public static TypeParamDef getNextGeneric(TypeDef type, Collection<TypeParamDef> excluded) {
        HashSet<String> skip = new HashSet<String>();
        for (String s : BuilderUtils.allGenericsOf(type)) {
            skip.add(s);
        }
        for (TypeParamDef e : excluded) {
            skip.add(e.getName());
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < GENERIC_NAMES.length; ++j) {
                String name = GENERIC_NAMES[j] + (i > 0 ? String.valueOf(i) : "");
                if (skip.contains(name)) continue;
                return ((TypeParamDefBuilder)new TypeParamDefBuilder().withName(name)).build();
            }
        }
        throw new IllegalStateException("Could not allocate generic parameter letter for: " + type.getFullyQualifiedName());
    }

    public static Set<String> allGenericsOf(TypeDef clazz) {
        HashSet<String> result = new HashSet<String>();
        for (TypeParamDef paramDef : clazz.getParameters()) {
            result.add(paramDef.getName());
        }
        for (Property property : clazz.getProperties()) {
            result.addAll(BuilderUtils.allGenericsOf(property));
        }
        for (Method method : clazz.getMethods()) {
            result.addAll(BuilderUtils.allGenericsOf(method));
        }
        return result;
    }

    public static Set<String> allGenericsOf(TypeRef type) {
        HashSet<String> result = new HashSet<String>();
        if (type instanceof ClassRef) {
            for (TypeRef ref : ((ClassRef)type).getArguments()) {
                if (!(ref instanceof TypeParamRef)) continue;
                result.add(((TypeParamRef)ref).getName());
            }
        }
        return result;
    }

    public static Collection<String> allGenericsOf(Property property) {
        return BuilderUtils.allGenericsOf(property.getTypeRef());
    }

    public static Collection<String> allGenericsOf(Method method) {
        HashSet<String> result = new HashSet<String>(BuilderUtils.allGenericsOf(method.getReturnType()));
        for (Property property : method.getArguments()) {
            result.addAll(BuilderUtils.allGenericsOf(property));
        }
        return result;
    }
}

