/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.spi.cluster.jgroups.impl.domain.MultiMap;
import io.vertx.spi.cluster.jgroups.impl.domain.SyncMapWrapper;
import io.vertx.spi.cluster.jgroups.impl.domain.async.AsyncMapWrapper;
import io.vertx.spi.cluster.jgroups.impl.domain.async.AsyncMultiMapWrapper;
import io.vertx.spi.cluster.jgroups.impl.services.DefaultRpcExecutorService;
import io.vertx.spi.cluster.jgroups.impl.services.DefaultRpcMapService;
import io.vertx.spi.cluster.jgroups.impl.services.DefaultRpcMultiMapService;
import io.vertx.spi.cluster.jgroups.impl.services.RpcExecutorService;
import io.vertx.spi.cluster.jgroups.impl.services.RpcMapService;
import io.vertx.spi.cluster.jgroups.impl.services.RpcMultiMapService;
import io.vertx.spi.cluster.jgroups.impl.services.RpcServerObjDelegate;
import io.vertx.spi.cluster.jgroups.impl.support.LambdaLogger;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.ReceiverAdapter;
import org.jgroups.blocks.RpcDispatcher;

public class CacheManager
extends ReceiverAdapter
implements LambdaLogger {
    private static final Logger LOG = LoggerFactory.getLogger(CacheManager.class);
    private JChannel channel;
    private final RpcDispatcher dispatcher;
    private final RpcExecutorService executorService;
    private final RpcMultiMapService multiMapService;
    private final RpcMapService mapService;

    public CacheManager(Vertx vertx, JChannel channel) {
        this.channel = channel;
        this.multiMapService = new DefaultRpcMultiMapService();
        this.mapService = new DefaultRpcMapService();
        RpcServerObjDelegate server_obj = new RpcServerObjDelegate(this.mapService, this.multiMapService);
        this.dispatcher = new RpcDispatcher((Channel)this.channel, (MessageListener)this, (MembershipListener)channel.getReceiver(), (Object)server_obj);
        this.dispatcher.setMethodLookup(server_obj.getMethodLookup());
        this.executorService = new DefaultRpcExecutorService(vertx, this.dispatcher);
    }

    public <K, V> AsyncMultiMap<K, V> createAsyncMultiMap(String name) {
        this.logDebug(() -> String.format("method createAsyncMultiMap address[%s] name[%s]", this.channel.getAddressAsString(), name));
        MultiMap map = this.multiMapService.multiMapCreate(name);
        return new AsyncMultiMapWrapper(name, map, this.executorService);
    }

    public <K, V> AsyncMap<K, V> createAsyncMap(String name) {
        this.logDebug(() -> String.format("method createAsyncMap address[%s] name[%s]", this.channel.getAddressAsString(), name));
        Map map = this.mapService.mapCreate(name);
        return new AsyncMapWrapper(name, map, this.executorService);
    }

    public <K, V> Map<K, V> createSyncMap(String name) {
        this.logDebug(() -> String.format("method createSyncMap address[%s] name[%s]", this.channel.getAddressAsString(), name));
        Map map = this.mapService.mapCreate(name);
        return new SyncMapWrapper(name, map, this.executorService);
    }

    @Override
    public Logger log() {
        return LOG;
    }

    public void getState(OutputStream output) throws Exception {
        this.logTrace(() -> "CacheManager get state");
        this.multiMapService.writeTo(output);
        this.mapService.writeTo(output);
    }

    public void setState(InputStream input) throws Exception {
        this.logTrace(() -> "CacheManager set state");
        this.multiMapService.readFrom(input);
        this.mapService.readFrom(input);
    }

    public void start() {
        try {
            this.channel.getState(null, 10000L);
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    public void stop() {
        this.dispatcher.stop();
        this.executorService.stop();
    }
}

