/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.domain;

import io.vertx.spi.cluster.jgroups.impl.domain.ChoosableArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jgroups.util.Util;

public class ChoosableArrayListImpl<T>
implements ChoosableArrayList<T> {
    private volatile List<T> values = new CopyOnWriteArrayList<T>();
    private volatile int roundRobinIndex = 0;

    @Override
    public ChoosableArrayList<T> add(T value) {
        this.values.add(value);
        return this;
    }

    @Override
    public ChoosableArrayList<T> remove(T value) {
        this.values.remove(value);
        return this;
    }

    @Override
    public T first() {
        return this.values.get(0);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public synchronized T choose() {
        if (this.roundRobinIndex >= this.values.size()) {
            this.roundRobinIndex = 0;
        }
        return this.values.get(this.roundRobinIndex++);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            this.writeTo(out);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        try {
            this.readFrom(in);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void writeTo(DataOutput out) throws Exception {
        out.writeInt(this.values.size());
        for (T value : this.values) {
            Util.writeObject(value, (DataOutput)out);
        }
    }

    public void readFrom(DataInput in) throws Exception {
        int size = in.readInt();
        Object[] buffer = new Object[size];
        for (int i = 0; i < size; ++i) {
            buffer[i] = Util.readObject((DataInput)in);
        }
        this.values = new CopyOnWriteArrayList<Object>(buffer);
    }

    public Iterator<T> iterator() {
        return this.values.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChoosableArrayListImpl)) {
            return false;
        }
        ChoosableArrayListImpl that = (ChoosableArrayListImpl)o;
        if (this.size() != that.size()) {
            return false;
        }
        for (T value : this.values) {
            if (that.values.contains(value)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.values != null ? this.values.hashCode() : 0;
        result = 31 * result + this.roundRobinIndex;
        return result;
    }

    public String toString() {
        String valuesToString = this.values.stream().map(Object::toString).collect(Collectors.joining(", "));
        return "[" + valuesToString + "]";
    }
}

