/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.domain;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;

public class ClusteredCounterImpl
implements Counter {
    private Vertx vertx;
    private org.jgroups.blocks.atomic.Counter counter;

    public ClusteredCounterImpl(Vertx vertx, org.jgroups.blocks.atomic.Counter counter) {
        this.vertx = vertx;
        this.counter = counter;
    }

    public void get(Handler<AsyncResult<Long>> handler) {
        this.vertx.executeBlocking(future -> future.complete((Object)this.counter.get()), handler);
    }

    public void incrementAndGet(Handler<AsyncResult<Long>> handler) {
        this.vertx.executeBlocking(future -> future.complete((Object)this.counter.incrementAndGet()), handler);
    }

    public void getAndIncrement(Handler<AsyncResult<Long>> handler) {
        this.vertx.executeBlocking(future -> future.complete((Object)(this.counter.incrementAndGet() - 1L)), handler);
    }

    public void decrementAndGet(Handler<AsyncResult<Long>> handler) {
        this.vertx.executeBlocking(future -> future.complete((Object)this.counter.decrementAndGet()), handler);
    }

    public void addAndGet(long delta, Handler<AsyncResult<Long>> handler) {
        this.vertx.executeBlocking(future -> future.complete((Object)this.counter.addAndGet(delta)), handler);
    }

    public void getAndAdd(long delta, Handler<AsyncResult<Long>> handler) {
        this.vertx.executeBlocking(future -> future.complete((Object)(this.counter.addAndGet(delta) - delta)), handler);
    }

    public void compareAndSet(long expected, long update, Handler<AsyncResult<Boolean>> handler) {
        this.vertx.executeBlocking(future -> future.complete((Object)this.counter.compareAndSet(expected, update)), handler);
    }
}

