/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.domain.async;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ChoosableIterable;
import io.vertx.spi.cluster.jgroups.impl.domain.MultiMap;
import io.vertx.spi.cluster.jgroups.impl.services.RpcExecutorService;
import io.vertx.spi.cluster.jgroups.impl.services.RpcServerObjDelegate;
import io.vertx.spi.cluster.jgroups.impl.support.LambdaLogger;

public class AsyncMultiMapWrapper<K, V>
implements AsyncMultiMap<K, V>,
LambdaLogger {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncMultiMapWrapper.class);
    private final String name;
    private final MultiMap<K, V> map;
    private final RpcExecutorService executorService;

    public AsyncMultiMapWrapper(String name, MultiMap<K, V> map, RpcExecutorService executorService) {
        this.name = name;
        this.map = map;
        this.executorService = executorService;
    }

    public void add(K k, V v, Handler<AsyncResult<Void>> handler) {
        this.logTrace(() -> "add k = [" + k + "], v = [" + v + "], handler = [" + handler + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MULTIMAP_ADD.method(this.name, k, v), handler);
    }

    public void get(K k, Handler<AsyncResult<ChoosableIterable<V>>> handler) {
        this.logTrace(() -> "get k = [" + k + "], handler = [" + handler + "]");
        this.executorService.runAsync(() -> this.map.get(k), handler);
    }

    public void remove(K k, V v, Handler<AsyncResult<Boolean>> handler) {
        this.logTrace(() -> "remove k = [" + k + "], v = [" + v + "], handler = [" + handler + "]");
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MULTIMAP_REMOVE.method(this.name, k, v), handler);
    }

    public void removeAllForValue(V v, Handler<AsyncResult<Void>> handler) {
        this.executorService.remoteExecute(RpcServerObjDelegate.CALL_MULTIMAP_REMOVE_ALL.method(this.name, v), handler);
    }

    @Override
    public Logger log() {
        return LOG;
    }
}

