/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.services;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.spi.cluster.jgroups.impl.domain.MultiMap;
import io.vertx.spi.cluster.jgroups.impl.services.MethodCallInterface;
import io.vertx.spi.cluster.jgroups.impl.services.RpcMapService;
import io.vertx.spi.cluster.jgroups.impl.services.RpcMultiMapService;
import io.vertx.spi.cluster.jgroups.impl.support.DataHolder;
import io.vertx.spi.cluster.jgroups.impl.support.LambdaLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;

public class RpcServerObjDelegate
implements RpcMapService,
RpcMultiMapService,
LambdaLogger {
    private static final Logger LOG = LoggerFactory.getLogger(RpcServerObjDelegate.class);
    private final RpcMapService mapService;
    private final RpcMultiMapService multiMapService;
    private static final short MULTIMAP_ADD = 11;
    private static final short MULTIMAP_REMOVE = 12;
    private static final short MULTIMAP_REMOVE_ALL = 13;
    private static final short MAP_PUT = 21;
    private static final short MAP_PUTIFABSENT = 22;
    private static final short MAP_REMOVE = 23;
    private static final short MAP_REMOVEIFPRESENT = 24;
    private static final short MAP_REPLACE = 25;
    private static final short MAP_REPLACEIFPRESENT = 26;
    private static final short MAP_CLEAR = 27;
    private static final short MAP_PUTALL = 28;
    public static final MethodCallInterface.ThreeParameters CALL_MULTIMAP_ADD = (name, p1, p2) -> new MethodCall(11, new Object[]{name, DataHolder.wrap(p1), DataHolder.wrap(p2)});
    public static final MethodCallInterface.ThreeParameters CALL_MULTIMAP_REMOVE = (name, p1, p2) -> new MethodCall(12, new Object[]{name, DataHolder.wrap(p1), DataHolder.wrap(p2)});
    public static final MethodCallInterface.TwoParameters CALL_MULTIMAP_REMOVE_ALL = (name, p1) -> new MethodCall(13, new Object[]{name, DataHolder.wrap(p1)});
    public static final MethodCallInterface.ThreeParameters CALL_MAP_PUT = (name, p1, p2) -> new MethodCall(21, new Object[]{name, DataHolder.wrap(p1), DataHolder.wrap(p2)});
    public static final MethodCallInterface.TwoParameters CALL_MAP_PUTALL = (name, p1) -> new MethodCall(22, new Object[]{name, DataHolder.wrap(p1)});
    public static final MethodCallInterface.ThreeParameters CALL_MAP_PUTIFABSENT = (name, p1, p2) -> new MethodCall(22, new Object[]{name, DataHolder.wrap(p1), DataHolder.wrap(p2)});
    public static final MethodCallInterface.TwoParameters CALL_MAP_REMOVE = (name, p1) -> new MethodCall(23, new Object[]{name, DataHolder.wrap(p1)});
    public static final MethodCallInterface.ThreeParameters CALL_MAP_REMOVEIFPRESENT = (name, p1, p2) -> new MethodCall(24, new Object[]{name, DataHolder.wrap(p1), DataHolder.wrap(p2)});
    public static final MethodCallInterface.ThreeParameters CALL_MAP_REPLACE = (name, p1, p2) -> new MethodCall(25, new Object[]{name, DataHolder.wrap(p1), DataHolder.wrap(p2)});
    public static final MethodCallInterface.FourParameters CALL_MAP_REPLACEIFPRESENT = (name, p1, p2, p3) -> new MethodCall(26, new Object[]{name, DataHolder.wrap(p1), DataHolder.wrap(p2), DataHolder.wrap(p3)});
    public static final MethodCallInterface.OneParameter CALL_MAP_CLEAR = name -> new MethodCall(27, new Object[]{name});
    private static final Map<Short, Method> methods = new HashMap<Short, Method>();

    public RpcServerObjDelegate(RpcMapService mapService, RpcMultiMapService multiMapService) {
        this.mapService = mapService;
        this.multiMapService = multiMapService;
    }

    public MethodLookup getMethodLookup() {
        return methods::get;
    }

    @Override
    public <K, V> MultiMap<K, V> multiMapCreate(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, V> void multiMapAdd(String name, DataHolder<K> k, DataHolder<V> v) {
        this.logTrace(() -> "RpcServerObjDelegate.multiMapAdd name = [" + name + "], k = [" + k + "], v = [" + v + "]");
        this.multiMapService.multiMapAdd(name, k, v);
    }

    @Override
    public <K, V> boolean multiMapRemove(String name, DataHolder<K> k, DataHolder<V> v) {
        this.logTrace(() -> "RpcServerObjDelegate.multiMapRemove name = [" + name + "], k = [" + k + "], v = [" + v + "]");
        return this.multiMapService.multiMapRemove(name, k, v);
    }

    @Override
    public <K, V> void multiMapRemoveAll(String name, DataHolder<V> v) {
        this.logTrace(() -> "RpcServerObjDelegate.multiMapRemoveAll name = [" + name + "], v = [" + v + "]");
        this.multiMapService.multiMapRemoveAll(name, v);
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFrom(InputStream input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, V> Map<K, V> mapCreate(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, V> void mapPut(String name, DataHolder<K> k, DataHolder<V> v) {
        this.mapService.mapPut(name, k, v);
    }

    @Override
    public <K, V> void mapPutAll(String name, Map<DataHolder<K>, DataHolder<V>> m) {
        this.mapService.mapPutAll(name, m);
    }

    @Override
    public <K, V> DataHolder<V> mapPutIfAbsent(String name, DataHolder<K> k, DataHolder<V> v) {
        return this.mapService.mapPutIfAbsent(name, k, v);
    }

    @Override
    public <K, V> DataHolder<V> mapRemove(String name, DataHolder<K> k) {
        return this.mapService.mapRemove(name, k);
    }

    @Override
    public <K, V> boolean mapRemoveIfPresent(String name, DataHolder<K> k, DataHolder<V> v) {
        return this.mapService.mapRemoveIfPresent(name, k, v);
    }

    @Override
    public <K, V> DataHolder<V> mapReplace(String name, DataHolder<K> k, DataHolder<V> v) {
        return this.mapService.mapReplace(name, k, v);
    }

    @Override
    public <K, V> boolean mapReplaceIfPresent(String name, DataHolder<K> k, DataHolder<V> oldValue, DataHolder<V> newValue) {
        return this.mapService.mapReplaceIfPresent(name, k, oldValue, newValue);
    }

    @Override
    public <K, V> void mapClear(String name) {
        this.mapService.mapClear(name);
    }

    @Override
    public Logger log() {
        return LOG;
    }

    static {
        try {
            methods.put((short)11, RpcServerObjDelegate.class.getMethod("multiMapAdd", String.class, DataHolder.class, DataHolder.class));
            methods.put((short)12, RpcServerObjDelegate.class.getMethod("multiMapRemove", String.class, DataHolder.class, DataHolder.class));
            methods.put((short)13, RpcServerObjDelegate.class.getMethod("multiMapRemoveAll", String.class, DataHolder.class));
            methods.put((short)21, RpcServerObjDelegate.class.getMethod("mapPut", String.class, DataHolder.class, DataHolder.class));
            methods.put((short)28, RpcServerObjDelegate.class.getMethod("mapPutAll", String.class, Map.class));
            methods.put((short)22, RpcServerObjDelegate.class.getMethod("mapPutIfAbsent", String.class, DataHolder.class, DataHolder.class));
            methods.put((short)23, RpcServerObjDelegate.class.getMethod("mapRemove", String.class, DataHolder.class));
            methods.put((short)24, RpcServerObjDelegate.class.getMethod("mapRemoveIfPresent", String.class, DataHolder.class, DataHolder.class));
            methods.put((short)25, RpcServerObjDelegate.class.getMethod("mapReplace", String.class, DataHolder.class, DataHolder.class));
            methods.put((short)26, RpcServerObjDelegate.class.getMethod("mapReplaceIfPresent", String.class, DataHolder.class, DataHolder.class, DataHolder.class));
            methods.put((short)27, RpcServerObjDelegate.class.getMethod("mapClear", String.class));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

