/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.support;

import io.vertx.spi.cluster.jgroups.impl.support.ComparedType;
import io.vertx.spi.cluster.jgroups.impl.support.ComparedValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayUtils {
    public static <T extends Comparable> T[] copySortAndFilter(T[] values) {
        Object[] copyOf = (Comparable[])Arrays.copyOf(values, values.length);
        Arrays.sort(copyOf);
        return ArrayUtils.filterDuplicatesInSortedArray((Comparable[])copyOf);
    }

    public static <T extends Comparable> T[] filterDuplicatesInSortedArray(T[] values) {
        if (values.length > 0) {
            int last = 0;
            for (int i = 1; i < values.length; ++i) {
                if (values[last] == null || values[i] == null || values[last].compareTo(values[i]) == 0) continue;
                values[++last] = values[i];
            }
            int newLength = last + 1;
            if (newLength < values.length) {
                return (Comparable[])Arrays.copyOf(values, newLength);
            }
            return values;
        }
        return values;
    }

    public static <T extends Comparable> List<ComparedValue<T>> compareSorted(T[] leftArray, T[] rightArray) {
        ArrayList<ComparedValue<T>> comparedValues = new ArrayList<ComparedValue<T>>(leftArray.length + rightArray.length);
        int leftIndex = 0;
        int rightIndex = 0;
        while (leftIndex < leftArray.length || rightIndex < rightArray.length) {
            Object right;
            Object left = leftIndex < leftArray.length ? (Object)leftArray[leftIndex] : null;
            int choose = ArrayUtils.compare(left, right = rightIndex < rightArray.length ? (Object)rightArray[rightIndex] : null);
            if (choose == 0) {
                ++leftIndex;
                ++rightIndex;
                comparedValues.add(new ComparedValue<Object>(left, ComparedType.EQUAL));
                continue;
            }
            if (choose < 0) {
                ++leftIndex;
                comparedValues.add(new ComparedValue<Object>(left, ComparedType.LEFT));
                continue;
            }
            ++rightIndex;
            comparedValues.add(new ComparedValue<Object>(right, ComparedType.RIGHT));
        }
        return comparedValues;
    }

    private static <T extends Comparable> int compare(T a, T b) {
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? 1 : -1;
        }
        return a.compareTo(b);
    }
}

