/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.jgroups.impl.support;

import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DataHolder<T>
implements Externalizable {
    private T data;

    public static <T> DataHolder wrap(T object) {
        DataHolder<T> dataHolder = new DataHolder<T>();
        dataHolder.data = object;
        return dataHolder;
    }

    public T unwrap() {
        return this.data;
    }

    public String toString() {
        return "DataHolder{" + this.data + "}";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        boolean isClusterSerializable = ClusterSerializable.class.isInstance(this.data);
        out.writeBoolean(isClusterSerializable);
        if (isClusterSerializable) {
            out.writeUTF(this.data.getClass().getName());
            Buffer buffer = Buffer.buffer();
            ((ClusterSerializable)this.data).writeToBuffer(buffer);
            byte[] bytes = buffer.getBytes();
            out.write(bytes.length);
            out.write(bytes);
        } else {
            out.writeObject(this.data);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isClusterSerializable = in.readBoolean();
        if (isClusterSerializable) {
            String className = in.readUTF();
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            try {
                this.data = clazz.newInstance();
                byte[] bytes = new byte[in.read()];
                in.read(bytes);
                ((ClusterSerializable)this.data).readFromBuffer(0, Buffer.buffer((byte[])bytes));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new VertxException((Throwable)e);
            }
        } else {
            this.data = in.readObject();
        }
    }
}

