/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.eventbus;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An event bus consumer object representing a stream of message to an {@link io.vertx.reactivex.core.eventbus.EventBus} address that can
 * be read from.
 * <p>
 * The {@link io.vertx.reactivex.core.eventbus.EventBus#consumer} or {@link io.vertx.reactivex.core.eventbus.EventBus#localConsumer}
 * creates a new consumer, the returned consumer is not yet registered against the event bus. Registration
 * is effective after the {@link io.vertx.reactivex.core.eventbus.MessageConsumer#handler} method is invoked.<p>
 *
 * The consumer is unregistered from the event bus using the {@link io.vertx.reactivex.core.eventbus.MessageConsumer#unregister} method or by calling the
 * {@link io.vertx.reactivex.core.eventbus.MessageConsumer#handler} with a null value..
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageConsumer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.core.eventbus.MessageConsumer.class)
public class MessageConsumer<T> implements ReadStream<Message<T>> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageConsumer that = (MessageConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<MessageConsumer> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new MessageConsumer((io.vertx.core.eventbus.MessageConsumer) obj),
    MessageConsumer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageConsumer delegate;
  public final io.vertx.lang.reactivex.TypeArg<T> __typeArg_0;
  
  public MessageConsumer(io.vertx.core.eventbus.MessageConsumer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.reactivex.TypeArg.unknown();
  }

  public MessageConsumer(io.vertx.core.eventbus.MessageConsumer delegate, io.vertx.lang.reactivex.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.eventbus.MessageConsumer getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<Message<T>> observable;
  private io.reactivex.Flowable<Message<T>> flowable;

  public synchronized io.reactivex.Observable<Message<T>> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.core.eventbus.Message, Message<T>> conv = Message::newInstance;
      observable = io.vertx.reactivex.ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<Message<T>> toFlowable() {
    if (flowable == null) {
      java.util.function.Function<io.vertx.core.eventbus.Message, Message<T>> conv = Message::newInstance;
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  public MessageConsumer<T> exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public MessageConsumer<T> handler(Handler<Message<T>> handler) { 
    delegate.handler(new Handler<io.vertx.core.eventbus.Message<T>>() {
      public void handle(io.vertx.core.eventbus.Message<T> event) {
        handler.handle(Message.newInstance(event, __typeArg_0));
      }
    });
    return this;
  }

  public MessageConsumer<T> pause() { 
    delegate.pause();
    return this;
  }

  public MessageConsumer<T> resume() { 
    delegate.resume();
    return this;
  }

  public MessageConsumer<T> endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @return a read stream for the body of the message stream.
   */
  public ReadStream<T> bodyStream() { 
    ReadStream<T> ret = ReadStream.newInstance(delegate.bodyStream(), __typeArg_0);
    return ret;
  }

  /**
   * @return true if the current consumer is registered
   */
  public boolean isRegistered() { 
    boolean ret = delegate.isRegistered();
    return ret;
  }

  /**
   * @return The address the handler was registered with.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * Set the number of messages this registration will buffer when this stream is paused. The default
   * value is <code>1000</code>. When a new value is set, buffered messages may be discarded to reach
   * the new value.
   * @param maxBufferedMessages the maximum number of messages that can be buffered
   * @return this registration
   */
  public MessageConsumer<T> setMaxBufferedMessages(int maxBufferedMessages) { 
    MessageConsumer<T> ret = MessageConsumer.newInstance(delegate.setMaxBufferedMessages(maxBufferedMessages), __typeArg_0);
    return ret;
  }

  /**
   * @return the maximum number of messages that can be buffered when this stream is paused
   */
  public int getMaxBufferedMessages() { 
    int ret = delegate.getMaxBufferedMessages();
    return ret;
  }

  /**
   * Optional method which can be called to indicate when the registration has been propagated across the cluster.
   * @param completionHandler the completion handler
   */
  public void completionHandler(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.completionHandler(completionHandler);
  }

  /**
   * Optional method which can be called to indicate when the registration has been propagated across the cluster.
   * @return 
   */
  public Completable rxCompletionHandler() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      completionHandler(handler);
    });
  }

  /**
   * Unregisters the handler which created this registration
   */
  public void unregister() { 
    delegate.unregister();
  }

  /**
   * Unregisters the handler which created this registration
   * @param completionHandler the handler called when the unregister is done. For example in a cluster when all nodes of the event bus have been unregistered.
   */
  public void unregister(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.unregister(completionHandler);
  }

  /**
   * Unregisters the handler which created this registration
   * @return 
   */
  public Completable rxUnregister() { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      unregister(handler);
    });
  }


  public static <T>MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg) {
    return arg != null ? new MessageConsumer<T>(arg) : null;
  }

  public static <T>MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg, io.vertx.lang.reactivex.TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageConsumer<T>(arg, __typeArg_T) : null;
  }
}
