/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.buffer.Buffer;

/**
 * A WebSocket frame that represents either text or binary data.
 * <p>
 * A WebSocket message is composed of one or more WebSocket frames.
 * <p>
 * If there is a just a single frame in the message then a single text or binary frame should be created with final = true.
 * <p>
 * If there are more than one frames in the message, then the first frame should be a text or binary frame with
 * final = false, followed by one or more continuation frames. The last continuation frame should have final = true.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketFrame original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.core.http.WebSocketFrame.class)
public class WebSocketFrame {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebSocketFrame that = (WebSocketFrame) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<WebSocketFrame> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new WebSocketFrame((io.vertx.core.http.WebSocketFrame) obj),
    WebSocketFrame::getDelegate
  );

  private final io.vertx.core.http.WebSocketFrame delegate;
  
  public WebSocketFrame(io.vertx.core.http.WebSocketFrame delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.http.WebSocketFrame getDelegate() {
    return delegate;
  }

  /**
   * Create a binary WebSocket frame.
   * @param data the data for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static WebSocketFrame binaryFrame(Buffer data, boolean isFinal) { 
    WebSocketFrame ret = WebSocketFrame.newInstance(io.vertx.core.http.WebSocketFrame.binaryFrame(data.getDelegate(), isFinal));
    return ret;
  }

  /**
   * Create a text WebSocket frame.
   * @param str the string for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static WebSocketFrame textFrame(String str, boolean isFinal) { 
    WebSocketFrame ret = WebSocketFrame.newInstance(io.vertx.core.http.WebSocketFrame.textFrame(str, isFinal));
    return ret;
  }

  /**
   * Create a ping WebSocket frame.  Will be a final frame. There is no option for non final ping frames.
   * @param data the bytes for the frame, may be at most 125 bytes
   * @return the frame
   */
  public static WebSocketFrame pingFrame(Buffer data) { 
    WebSocketFrame ret = WebSocketFrame.newInstance(io.vertx.core.http.WebSocketFrame.pingFrame(data.getDelegate()));
    return ret;
  }

  /**
   * Create a pong WebSocket frame.  Will be a final frame. There is no option for non final pong frames.
   * @param data the bytes for the frame, may be at most 125 bytes
   * @return the frame
   */
  public static WebSocketFrame pongFrame(Buffer data) { 
    WebSocketFrame ret = WebSocketFrame.newInstance(io.vertx.core.http.WebSocketFrame.pongFrame(data.getDelegate()));
    return ret;
  }

  /**
   * Create a continuation frame
   * @param data the data for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static WebSocketFrame continuationFrame(Buffer data, boolean isFinal) { 
    WebSocketFrame ret = WebSocketFrame.newInstance(io.vertx.core.http.WebSocketFrame.continuationFrame(data.getDelegate(), isFinal));
    return ret;
  }

  /**
   * @return true if it's a text frame
   */
  public boolean isText() { 
    boolean ret = delegate.isText();
    return ret;
  }

  /**
   * @return true if it's a binary frame
   */
  public boolean isBinary() { 
    boolean ret = delegate.isBinary();
    return ret;
  }

  /**
   * @return true if it's a continuation frame
   */
  public boolean isContinuation() { 
    boolean ret = delegate.isContinuation();
    return ret;
  }

  /**
   * @return true if it's close frame
   */
  public boolean isClose() { 
    boolean ret = delegate.isClose();
    return ret;
  }

  /**
   * @return the content of this frame as a UTF-8 string and returns the converted string. Only use this for text frames.
   */
  public String textData() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.textData();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the data of the frame
   */
  public Buffer binaryData() { 
    if (cached_1 != null) {
      return cached_1;
    }
    Buffer ret = Buffer.newInstance(delegate.binaryData());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this is the final frame.
   */
  public boolean isFinal() { 
    boolean ret = delegate.isFinal();
    return ret;
  }

  /**
   * @return status code of close frame. Only use this for close frames
   */
  public short closeStatusCode() { 
    short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * @return string explaining close reason. Only use this for close frames
   */
  public String closeReason() { 
    String ret = delegate.closeReason();
    return ret;
  }

  private String cached_0;
  private Buffer cached_1;

  public static  WebSocketFrame newInstance(io.vertx.core.http.WebSocketFrame arg) {
    return arg != null ? new WebSocketFrame(arg) : null;
  }
}
