/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.parsetools;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.json.JsonArray;
import io.vertx.core.parsetools.JsonEventType;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;

/**
 * A JSON event emited by the {@link io.vertx.reactivex.core.parsetools.JsonParser}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.parsetools.JsonEvent original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.core.parsetools.JsonEvent.class)
public class JsonEvent {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonEvent that = (JsonEvent) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<JsonEvent> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new JsonEvent((io.vertx.core.parsetools.JsonEvent) obj),
    JsonEvent::getDelegate
  );

  private final io.vertx.core.parsetools.JsonEvent delegate;
  
  public JsonEvent(io.vertx.core.parsetools.JsonEvent delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.parsetools.JsonEvent getDelegate() {
    return delegate;
  }

  /**
   * @return the type of the event
   */
  public JsonEventType type() { 
    JsonEventType ret = delegate.type();
    return ret;
  }

  /**
   * @return the name of the field when the event is emitted as a JSON object member
   */
  public String fieldName() { 
    String ret = delegate.fieldName();
    return ret;
  }

  /**
   * @return the json value for  events
   */
  public Object value() { 
    Object ret = (Object) delegate.value();
    return ret;
  }

  /**
   * @return true when the JSON value is a number
   */
  public boolean isNumber() { 
    boolean ret = delegate.isNumber();
    return ret;
  }

  /**
   * @return the <code>Integer</code> value or <code>null</code> if the event has no JSON value
   */
  public Integer integerValue() { 
    Integer ret = delegate.integerValue();
    return ret;
  }

  /**
   * @return the <code>Long</code> value or <code>null</code> if the event has no JSON value
   */
  public Long longValue() { 
    Long ret = delegate.longValue();
    return ret;
  }

  /**
   * @return the <code>Float</code> value or <code>null</code> if the event has no JSON value
   */
  public Float floatValue() { 
    Float ret = delegate.floatValue();
    return ret;
  }

  /**
   * @return the <code>Double</code> value or <code>null</code> if the event has no JSON value
   */
  public Double doubleValue() { 
    Double ret = delegate.doubleValue();
    return ret;
  }

  /**
   * @return true when the JSON value is a boolean
   */
  public boolean isBoolean() { 
    boolean ret = delegate.isBoolean();
    return ret;
  }

  /**
   * @return the <code>Boolean</code> value or <code>null</code> if the event has no JSON value
   */
  public Boolean booleanValue() { 
    Boolean ret = delegate.booleanValue();
    return ret;
  }

  /**
   * @return true when the JSON value is a string
   */
  public boolean isString() { 
    boolean ret = delegate.isString();
    return ret;
  }

  /**
   * @return the string value or <code>null</code> if the event has no JSON value
   */
  public String stringValue() { 
    String ret = delegate.stringValue();
    return ret;
  }

  /**
   * Return the binary value.
   * <p>
   * JSON itself has no notion of a binary, this extension complies to the RFC-7493, so this method assumes there is a
   * String value with the key and it contains a Base64 encoded binary, which it decodes if found and returns.
   * @return the binary value or <code>null</code> if the event has no JSON value
   */
  public Buffer binaryValue() { 
    Buffer ret = Buffer.newInstance(delegate.binaryValue());
    return ret;
  }

  /**
   * @return true when the JSON value is null
   */
  public boolean isNull() { 
    boolean ret = delegate.isNull();
    return ret;
  }

  /**
   * @return true when the JSON value is a JSON object
   */
  public boolean isObject() { 
    boolean ret = delegate.isObject();
    return ret;
  }

  /**
   * @return the JSON object value or <code>null</code> if the event has no JSON value
   */
  public JsonObject objectValue() { 
    JsonObject ret = delegate.objectValue();
    return ret;
  }

  /**
   * @return true when the JSON value is a JSON array
   */
  public boolean isArray() { 
    boolean ret = delegate.isArray();
    return ret;
  }

  /**
   * @return the JSON array value or <code>null</code> if the event has no JSON value
   */
  public JsonArray arrayValue() { 
    JsonArray ret = delegate.arrayValue();
    return ret;
  }

  /**
   * Decodes and returns the current value as the specified <code>type</code>.
   * @param type the type to decode the value to
   * @return the decoded value
   */
  public <T> T mapTo(Class<T> type) { 
    T ret = (T)io.vertx.lang.reactivex.TypeArg.of(type).wrap(delegate.mapTo(io.vertx.lang.reactivex.Helper.unwrap(type)));
    return ret;
  }


  public static  JsonEvent newInstance(io.vertx.core.parsetools.JsonEvent arg) {
    return arg != null ? new JsonEvent(arg) : null;
  }
}
