/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.command.Command;
import io.vertx.ext.shell.command.CommandBuilder;
import io.vertx.ext.shell.command.CommandProcess;
import io.vertx.ext.shell.session.Session;
import io.vertx.ext.shell.system.ExecStatus;
import io.vertx.ext.shell.system.Process;
import io.vertx.ext.shell.term.Pty;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class CommandProcessTest {
    Vertx vertx;

    @Before
    public void before() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    private Process createProcessInContext(Context context, Command command) throws Exception {
        CompletableFuture fut = new CompletableFuture();
        context.runOnContext(v -> {
            Process process = command.createProcess().setSession(Session.create()).setTty(Pty.create().slave());
            fut.complete(process);
        });
        return (Process)fut.get(2000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testRunReadyProcess(TestContext context) throws Exception {
        AtomicInteger status = new AtomicInteger();
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async runningLatch = context.async(1);
        builder.processHandler(process -> {
            context.assertEquals((Object)0, (Object)status.getAndIncrement());
            runningLatch.countDown();
            process.end();
        });
        Command command = builder.build(this.vertx);
        Context ctx = this.vertx.getOrCreateContext();
        Process process2 = this.createProcessInContext(ctx, command);
        context.assertEquals((Object)ExecStatus.READY, (Object)process2.status());
        process2.run();
        context.assertEquals((Object)ExecStatus.RUNNING, (Object)process2.status());
        runningLatch.awaitSuccess(5000L);
        long now = System.currentTimeMillis();
        while (process2.status() != ExecStatus.TERMINATED) {
            context.assertTrue(System.currentTimeMillis() - now < 5000L);
        }
    }

    @Test
    public void testRunRunningProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async runningLatch = context.async();
        builder.processHandler(process -> runningLatch.complete());
        Process process2 = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        process2.run();
        runningLatch.awaitSuccess(10000L);
        try {
            process2.run();
            context.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRunSuspendedProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async suspendedLatch = context.async();
        Async runningLatch = context.async();
        builder.processHandler(process -> {
            process.suspendHandler(v -> suspendedLatch.complete());
            runningLatch.complete();
        });
        Process process2 = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        process2.run();
        runningLatch.awaitSuccess(10000L);
        process2.suspend();
        suspendedLatch.awaitSuccess(10000L);
        try {
            process2.run();
            context.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static Handler<ExecStatus> terminateHandler(Handler<Void> handler) {
        return status -> {
            if (status == ExecStatus.TERMINATED) {
                handler.handle(null);
            }
        };
    }

    @Test
    public void testRunTerminatedProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async terminatedLatch = context.async();
        builder.processHandler(CommandProcess::end);
        Process process = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        process.terminatedHandler(exitCode -> terminatedLatch.complete());
        process.run();
        terminatedLatch.awaitSuccess(10000L);
        try {
            process.run();
            context.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSuspendReadyProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        builder.processHandler(process -> context.fail());
        Process process2 = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        try {
            process2.suspend();
            context.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSuspendRunningProcess(TestContext context) throws Exception {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        AtomicInteger status = new AtomicInteger();
        Async suspendedLatch = context.async(2);
        Async runningLatch = context.async();
        builder.processHandler(process -> {
            context.assertEquals((Object)0, (Object)status.getAndIncrement());
            process.suspendHandler(v -> suspendedLatch.complete());
            runningLatch.complete();
        });
        Context ctx = this.vertx.getOrCreateContext();
        Process process2 = this.createProcessInContext(ctx, builder.build(this.vertx));
        process2.run();
        runningLatch.awaitSuccess(10000L);
        process2.suspend(v -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            context.assertEquals((Object)1, (Object)status.getAndIncrement());
            suspendedLatch.countDown();
        });
    }

    @Test
    public void testSuspendSuspendedProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async suspendedLatch = context.async();
        Async runningLatch = context.async();
        builder.processHandler(process -> {
            process.suspendHandler(v -> suspendedLatch.complete());
            runningLatch.complete();
        });
        Process process2 = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        process2.run();
        runningLatch.awaitSuccess(10000L);
        process2.suspend();
        suspendedLatch.awaitSuccess(10000L);
        try {
            process2.suspend();
            context.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSuspendTerminatedProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async terminatedLatch = context.async();
        builder.processHandler(CommandProcess::end);
        Process process = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        process.terminatedHandler(exitCode -> terminatedLatch.complete());
        process.run();
        terminatedLatch.awaitSuccess(10000L);
        try {
            process.suspend();
            context.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testResumeReadyProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        builder.processHandler(process -> context.fail());
        Process process2 = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        try {
            process2.resume();
            context.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testResumeRunningProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async runningLatch = context.async();
        builder.processHandler(process -> runningLatch.complete());
        Process process2 = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        process2.run();
        runningLatch.awaitSuccess(10000L);
        try {
            process2.resume();
            context.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testResumeSuspendedProcess(TestContext context) throws Exception {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        AtomicInteger status = new AtomicInteger();
        Async runningLatch = context.async();
        Async suspendedLatch = context.async();
        Async resumedLatch = context.async(2);
        builder.processHandler(process -> {
            process.suspendHandler(v -> suspendedLatch.complete());
            process.resumeHandler(v -> {
                context.assertEquals((Object)0, (Object)status.getAndIncrement());
                resumedLatch.countDown();
            });
            runningLatch.complete();
        });
        Context ctx = this.vertx.getOrCreateContext();
        Process process2 = this.createProcessInContext(ctx, builder.build(this.vertx));
        process2.run();
        runningLatch.awaitSuccess(10000L);
        process2.suspend();
        suspendedLatch.awaitSuccess(10000L);
        process2.resume(v -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            context.assertEquals((Object)1, (Object)status.getAndIncrement());
            resumedLatch.countDown();
        });
    }

    @Test
    public void testResumeTerminatedProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async terminatedLatch = context.async();
        builder.processHandler(CommandProcess::end);
        Process process = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        process.terminatedHandler(exitCode -> terminatedLatch.complete());
        process.run();
        terminatedLatch.awaitSuccess(10000L);
        try {
            process.resume();
            context.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInterruptReadyProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        builder.processHandler(process -> context.fail());
        Process process2 = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        try {
            process2.interrupt();
            context.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInterruptRunningProcess(TestContext context) throws Exception {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        AtomicInteger status = new AtomicInteger();
        Async runningLatch = context.async();
        Async interruptedLatch = context.async(6);
        builder.processHandler(process -> {
            process.interruptHandler(v -> interruptedLatch.countDown());
            runningLatch.complete();
        });
        Context ctx = this.vertx.getOrCreateContext();
        Process process2 = this.createProcessInContext(ctx, builder.build(this.vertx));
        process2.run();
        runningLatch.awaitSuccess(10000L);
        process2.interrupt(v -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            context.assertEquals((Object)0, (Object)status.getAndIncrement());
            interruptedLatch.countDown();
        });
        process2.interrupt(v -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            context.assertEquals((Object)1, (Object)status.getAndIncrement());
            interruptedLatch.countDown();
        });
        process2.interrupt(v -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            context.assertEquals((Object)2, (Object)status.getAndIncrement());
            interruptedLatch.countDown();
        });
    }

    @Test
    public void testInterruptSuspendedProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async runningLatch = context.async();
        Async suspendedLatch = context.async();
        Async interruptedLatch = context.async(3);
        builder.processHandler(process -> {
            process.interruptHandler(v -> interruptedLatch.countDown());
            process.suspendHandler(v -> suspendedLatch.complete());
            runningLatch.complete();
        });
        Process process2 = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        process2.run();
        runningLatch.awaitSuccess(10000L);
        process2.suspend();
        suspendedLatch.awaitSuccess(10000L);
        process2.interrupt();
        process2.interrupt();
        process2.interrupt();
    }

    @Test
    public void testInterruptTerminatedProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async terminatedLatch = context.async();
        builder.processHandler(process -> process.end());
        Process process2 = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        process2.terminatedHandler(exitCode -> terminatedLatch.complete());
        process2.run();
        terminatedLatch.awaitSuccess(10000L);
        try {
            process2.interrupt();
            context.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTerminateRunningProcess(TestContext context) throws Exception {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        AtomicInteger status = new AtomicInteger();
        Async terminatedLatch = context.async(3);
        Async runningLatch = context.async();
        builder.processHandler(process -> {
            process.endHandler(v -> {
                context.assertEquals((Object)0, (Object)status.getAndIncrement());
                terminatedLatch.countDown();
            });
            runningLatch.complete();
        });
        Context ctx = this.vertx.getOrCreateContext();
        Process process2 = this.createProcessInContext(ctx, builder.build(this.vertx));
        process2.terminatedHandler(exitCode -> terminatedLatch.countDown());
        process2.run();
        runningLatch.awaitSuccess(10000L);
        process2.terminate(v -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            context.assertEquals((Object)1, (Object)status.getAndIncrement());
            terminatedLatch.countDown();
        });
    }

    @Test
    public void testTerminateSuspendedProcess(TestContext context) throws Exception {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        AtomicInteger status = new AtomicInteger();
        Async runningLatch = context.async();
        Async suspendedLatch = context.async();
        Async terminatedLatch = context.async();
        builder.processHandler(process -> {
            process.suspendHandler(v -> suspendedLatch.complete());
            process.endHandler(v -> {
                context.assertEquals((Object)0, (Object)status.getAndIncrement());
                terminatedLatch.countDown();
            });
            runningLatch.complete();
        });
        Context ctx = this.vertx.getOrCreateContext();
        Process process2 = this.createProcessInContext(ctx, builder.build(this.vertx));
        process2.terminatedHandler(exitCode -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            terminatedLatch.countDown();
        });
        process2.run();
        runningLatch.awaitSuccess(10000L);
        process2.suspend();
        suspendedLatch.awaitSuccess(10000L);
        process2.terminate(v -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            context.assertEquals((Object)1, (Object)status.getAndIncrement());
            terminatedLatch.countDown();
        });
    }

    @Test
    public void testTerminateReadyProcess(TestContext context) throws Exception {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async terminatedLatch = context.async(2);
        builder.processHandler(process -> context.fail());
        Context ctx = this.vertx.getOrCreateContext();
        Process process2 = this.createProcessInContext(ctx, builder.build(this.vertx));
        process2.terminatedHandler(exitCode -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            terminatedLatch.countDown();
        });
        process2.terminate(v -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            terminatedLatch.countDown();
        });
    }

    @Test
    public void testTerminateTerminatedProcess(TestContext context) {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async runningLatch = context.async();
        Async terminatedLatch = context.async();
        builder.processHandler(process -> runningLatch.complete());
        Process process2 = builder.build(this.vertx).createProcess().setSession(Session.create()).setTty(Pty.create().slave());
        process2.terminatedHandler(exitCode -> terminatedLatch.complete());
        process2.run();
        runningLatch.awaitSuccess(10000L);
        process2.terminate();
        terminatedLatch.awaitSuccess(10000L);
        try {
            process2.terminate();
            context.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEndRunningProcess(TestContext context) throws Exception {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async endedHandler = context.async();
        builder.processHandler(process -> {
            process.endHandler(v -> endedHandler.complete());
            process.end(0);
        });
        Context ctx = this.vertx.getOrCreateContext();
        Process process2 = this.createProcessInContext(ctx, builder.build(this.vertx));
        Async terminatedHandler = context.async();
        process2.terminatedHandler(exitCode -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            terminatedHandler.complete();
        });
        process2.run();
    }

    @Test
    public void testEndSuspendedProcess(TestContext context) throws Exception {
        CommandBuilder builder = CommandBuilder.command((String)"hello");
        Async runningLatch = context.async();
        Async endedHandler = context.async();
        builder.processHandler(process -> {
            process.suspendHandler(v -> process.end(0));
            process.endHandler(v -> endedHandler.complete());
            runningLatch.complete();
        });
        Context ctx = this.vertx.getOrCreateContext();
        Process process2 = this.createProcessInContext(ctx, builder.build(this.vertx));
        Async terminatedHandler = context.async();
        process2.terminatedHandler(exitCode -> {
            context.assertEquals((Object)ctx, (Object)Vertx.currentContext());
            terminatedHandler.complete();
        });
        process2.run();
        runningLatch.awaitSuccess(10000L);
        process2.suspend();
    }
}

