/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.Vertx;
import io.vertx.ext.shell.command.CommandRegistry;
import io.vertx.ext.shell.command.base.FsHelper;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class FsTest {
    File root;
    Vertx vertx;
    CommandRegistry registry;
    FsHelper helper;

    @Before
    public void before() throws Exception {
        File target = new File(System.getProperty("vertx.test.dir", "target"));
        this.root = Files.createTempDirectory(target.toPath(), "fs", new FileAttribute[0]).toFile();
        System.setProperty("vertx.cwd", this.root.getAbsolutePath());
        this.vertx = Vertx.vertx();
        this.registry = CommandRegistry.getShared((Vertx)this.vertx);
        this.helper = new FsHelper();
    }

    @After
    public void after() {
        System.clearProperty("vertx.cwd");
        this.vertx.close();
    }

    @Test
    public void testCd(TestContext context) throws IOException {
        String dir_A = new File(this.root, "dir_A").getAbsolutePath();
        String file_B = new File(this.root, "file_B").getAbsolutePath();
        String dir_C = new File(this.root, "dir_C").getAbsolutePath();
        String dir_D = new File(new File(dir_C), "dir_D").getAbsolutePath();
        String file_E = new File(new File(dir_C), "file_E").getAbsolutePath();
        context.assertTrue(new File(dir_A).mkdir());
        context.assertTrue(new File(file_B).createNewFile());
        context.assertTrue(new File(dir_C).mkdir());
        context.assertTrue(new File(dir_D).mkdir());
        context.assertTrue(new File(file_E).createNewFile());
        this.helper.cd(this.vertx.fileSystem(), null, "dir_A", context.asyncAssertSuccess(path -> context.assertEquals((Object)dir_A, path)));
        this.helper.cd(this.vertx.fileSystem(), null, "dir_A/", context.asyncAssertSuccess(path -> context.assertEquals((Object)dir_A, path)));
        this.helper.cd(this.vertx.fileSystem(), null, "dir_A/.", context.asyncAssertSuccess(path -> context.assertEquals((Object)dir_A, path)));
        this.helper.cd(this.vertx.fileSystem(), null, "./dir_A", context.asyncAssertSuccess(path -> context.assertEquals((Object)dir_A, path)));
        this.helper.cd(this.vertx.fileSystem(), null, dir_A, context.asyncAssertSuccess(path -> context.assertEquals((Object)dir_A, path)));
        this.helper.cd(this.vertx.fileSystem(), null, dir_A + "/", context.asyncAssertSuccess(path -> context.assertEquals((Object)dir_A, path)));
        this.helper.cd(this.vertx.fileSystem(), null, "/", context.asyncAssertSuccess(path -> context.assertEquals((Object)"/", path)));
        this.helper.cd(this.vertx.fileSystem(), dir_C, "dir_D", context.asyncAssertSuccess(path -> context.assertEquals((Object)dir_D, path)));
        this.helper.cd(this.vertx.fileSystem(), dir_C, "dir_D/", context.asyncAssertSuccess(path -> context.assertEquals((Object)dir_D, path)));
        this.helper.cd(this.vertx.fileSystem(), dir_C, "dir_D/.", context.asyncAssertSuccess(path -> context.assertEquals((Object)dir_D, path)));
        this.helper.cd(this.vertx.fileSystem(), dir_C, "./dir_D", context.asyncAssertSuccess(path -> context.assertEquals((Object)dir_D, path)));
        this.helper.cd(this.vertx.fileSystem(), dir_C, "/", context.asyncAssertSuccess(path -> context.assertEquals((Object)"/", path)));
        this.helper.cd(this.vertx.fileSystem(), null, "file_B", context.asyncAssertFailure());
        this.helper.cd(this.vertx.fileSystem(), dir_C, "file_E", context.asyncAssertFailure());
        this.helper.cd(this.vertx.fileSystem(), null, "dir_", context.asyncAssertFailure());
        this.helper.cd(this.vertx.fileSystem(), null, "does_not_exists", context.asyncAssertFailure());
        this.helper.cd(this.vertx.fileSystem(), dir_C, "dir_", context.asyncAssertFailure());
        this.helper.cd(this.vertx.fileSystem(), dir_C, "does_not_exists", context.asyncAssertFailure());
    }

    @Test
    public void testLs(TestContext context) throws IOException {
        String dir_A = new File(this.root, "dir_A").getAbsolutePath();
        String file_B = new File(this.root, "file_B").getAbsolutePath();
        String dir_C = new File(this.root, "dir_C").getAbsolutePath();
        String dir_D = new File(new File(dir_C), "dir_D").getAbsolutePath();
        String file_E = new File(new File(dir_C), "file_E").getAbsolutePath();
        String file_F = new File(new File(dir_D), "file_F").getAbsolutePath();
        String file_G = new File(new File(dir_D), "file_G").getAbsolutePath();
        context.assertTrue(new File(dir_A).mkdir());
        context.assertTrue(new File(file_B).createNewFile());
        context.assertTrue(new File(dir_C).mkdir());
        context.assertTrue(new File(dir_D).mkdir());
        context.assertTrue(new File(file_E).createNewFile());
        context.assertTrue(new File(file_F).createNewFile());
        context.assertTrue(new File(file_G).createNewFile());
        this.helper.ls(this.vertx, null, ".", context.asyncAssertSuccess(files -> context.assertEquals(new HashSet<String>(Arrays.asList(dir_A, dir_C, file_B)), new HashSet(files.keySet()))));
        this.helper.ls(this.vertx, null, "dir_C", context.asyncAssertSuccess(files -> context.assertEquals(new HashSet<String>(Arrays.asList(dir_D, file_E)), new HashSet(files.keySet()))));
        this.helper.ls(this.vertx, null, "./dir_C", context.asyncAssertSuccess(files -> context.assertEquals(new HashSet<String>(Arrays.asList(dir_D, file_E)), new HashSet(files.keySet()))));
        this.helper.ls(this.vertx, null, "./dir_C/..", context.asyncAssertSuccess(files -> context.assertEquals(new HashSet<String>(Arrays.asList(dir_A, dir_C, file_B)), new HashSet(files.keySet()))));
        this.helper.ls(this.vertx, this.root.getAbsolutePath(), ".", context.asyncAssertSuccess(files -> context.assertEquals(new HashSet<String>(Arrays.asList(dir_A, dir_C, file_B)), new HashSet(files.keySet()))));
        this.helper.ls(this.vertx, this.root.getAbsolutePath(), dir_C, context.asyncAssertSuccess(files -> context.assertEquals(new HashSet<String>(Arrays.asList(dir_D, file_E)), new HashSet(files.keySet()))));
        this.helper.ls(this.vertx, this.root.getAbsolutePath(), "dir_C/dir_D", context.asyncAssertSuccess(files -> context.assertEquals(new HashSet<String>(Arrays.asList(file_F, file_G)), new HashSet(files.keySet()))));
        this.helper.ls(this.vertx, this.root.getAbsolutePath(), "./dir_C/dir_D", context.asyncAssertSuccess(files -> context.assertEquals(new HashSet<String>(Arrays.asList(file_F, file_G)), new HashSet(files.keySet()))));
    }

    @Test
    public void complete(TestContext context) throws Exception {
        String foo11 = new File(this.root, "foo11").getAbsolutePath();
        String foo22 = new File(this.root, "foo22").getAbsolutePath();
        String foo33 = new File(this.root, "foo33").getAbsolutePath();
        String bar11 = new File(foo11, "bar11").getAbsolutePath();
        String bar22 = new File(foo11, "bar22").getAbsolutePath();
        String bar33 = new File(foo11, "bar33").getAbsolutePath();
        context.assertTrue(new File(foo11).mkdir());
        context.assertTrue(new File(foo22).mkdir());
        context.assertTrue(new File(foo33).createNewFile());
        context.assertTrue(new File(bar11).mkdir());
        context.assertTrue(new File(bar22).mkdir());
        context.assertTrue(new File(bar33).createNewFile());
        this.helper.complete(this.vertx, null, "foo11", context.asyncAssertSuccess(result -> context.assertEquals(Collections.singletonMap("/", false), result)));
        this.helper.complete(this.vertx, null, "foo1", context.asyncAssertSuccess(result -> context.assertEquals(Collections.singletonMap("1/", false), result)));
        this.helper.complete(this.vertx, null, "foo", context.asyncAssertSuccess(result -> {
            HashMap<String, Boolean> expected = new HashMap<String, Boolean>();
            expected.put("foo11/", false);
            expected.put("foo22/", false);
            expected.put("foo33", true);
            context.assertEquals(expected, result);
        }));
        this.helper.complete(this.vertx, null, "", context.asyncAssertSuccess(result -> {
            HashMap<String, Boolean> expected = new HashMap<String, Boolean>();
            expected.put("foo", false);
            context.assertEquals(expected, result);
        }));
        this.helper.complete(this.vertx, null, "foo11/", context.asyncAssertSuccess(result -> {
            HashMap<String, Boolean> expected = new HashMap<String, Boolean>();
            expected.put("bar", false);
            context.assertEquals(expected, result);
        }));
        this.helper.complete(this.vertx, null, "foo11/bar", context.asyncAssertSuccess(result -> {
            HashMap<String, Boolean> expected = new HashMap<String, Boolean>();
            expected.put("bar11/", false);
            expected.put("bar22/", false);
            expected.put("bar33", true);
            context.assertEquals(expected, result);
        }));
    }
}

