/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import io.termd.core.TestBase;
import io.termd.core.telnet.TelnetHandler;
import io.termd.core.telnet.TelnetTermTest;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetServer;
import io.vertx.ext.shell.term.impl.TelnetSocketHandler;
import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public class VertxTelnetTermTest
extends TelnetTermTest {
    public static final Function<Supplier<TelnetHandler>, Closeable> VERTX_SERVER = handlerFactory -> {
        AsyncResult result;
        Vertx vertx = Vertx.vertx();
        NetServer server = vertx.createNetServer().connectHandler((Handler)new TelnetSocketHandler(vertx, handlerFactory));
        ArrayBlockingQueue latch = new ArrayBlockingQueue(1);
        server.listen(4000, "localhost", latch::add);
        try {
            result = (AsyncResult)latch.poll(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw TestBase.failure((Throwable)e);
        }
        if (result.failed()) {
            throw TestBase.failure((Throwable)result.cause());
        }
        return () -> {
            CountDownLatch closeLatch = new CountDownLatch(1);
            vertx.close(done -> closeLatch.countDown());
            try {
                closeLatch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
    };

    protected Function<Supplier<TelnetHandler>, Closeable> serverFactory() {
        return VERTX_SERVER;
    }
}

