/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term.impl;

import io.termd.core.readline.Keymap;
import io.termd.core.tty.TtyConnection;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.term.SockJSTermHandler;
import io.vertx.ext.shell.term.Term;
import io.vertx.ext.shell.term.impl.SockJSTtyConnection;
import io.vertx.ext.shell.term.impl.TermImpl;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import java.nio.charset.Charset;
import java.util.function.Consumer;

public class SockJSTermHandlerImpl
implements SockJSTermHandler {
    final Charset charset;
    final Vertx vertx;
    private Handler<Term> termHandler;
    private final Keymap keymap;

    public SockJSTermHandlerImpl(Vertx vertx, Charset charset, Keymap keymap) {
        this.charset = charset;
        this.vertx = vertx;
        this.keymap = keymap;
    }

    @Override
    public SockJSTermHandler termHandler(Handler<Term> handler) {
        this.termHandler = handler;
        return this;
    }

    public void handle(SockJSSocket socket) {
        if (this.termHandler != null) {
            SockJSTtyConnection conn = new SockJSTtyConnection(this.charset, this.vertx.getOrCreateContext(), socket);
            socket.handler(buf -> conn.writeToDecoder(buf.toString()));
            socket.endHandler(v -> {
                Consumer closeHandler = conn.getCloseHandler();
                if (closeHandler != null) {
                    closeHandler.accept(null);
                }
            });
            this.termHandler.handle((Object)new TermImpl(this.vertx, this.keymap, (TtyConnection)conn));
        } else {
            socket.close();
        }
    }
}

