/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.WebDevice;
import io.webdevice.test.UnitTest;
import io.webdevice.wiring.WebDeviceListener;
import io.webdevice.wiring.WebDeviceScope;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

public class WebDeviceListenerTest
extends UnitTest {
    private WebDeviceListener listener;
    @Mock
    private TestContext mockTestContext;
    @Mock
    private ApplicationContext mockApplicationContext;
    @Mock
    private ConfigurableApplicationContext mockConfigurableContext;
    @Mock
    private ConfigurableListableBeanFactory mockBeanFactory;

    @Before
    public void setUp() {
        this.listener = new WebDeviceListener();
    }

    @Test
    public void shouldDoNothingWhenScopeIsNull() {
        BDDMockito.given((Object)this.mockTestContext.getApplicationContext()).willReturn((Object)this.mockApplicationContext);
        this.listener.afterTestMethod(this.mockTestContext);
        ((TestContext)Mockito.verify((Object)this.mockTestContext)).getApplicationContext();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockConfigurableContext, this.mockApplicationContext, this.mockTestContext});
    }

    @Test
    public void shouldDoNothingWhenScopeWasNotDisposed() {
        WebDeviceScope scope = new WebDeviceScope();
        Assertions.assertThat((boolean)scope.dispose()).isFalse();
        BDDMockito.given((Object)this.mockTestContext.getApplicationContext()).willReturn((Object)this.mockConfigurableContext);
        BDDMockito.given((Object)this.mockConfigurableContext.getBeanFactory()).willReturn((Object)this.mockBeanFactory);
        BDDMockito.given((Object)this.mockBeanFactory.getRegisteredScope("webdevice")).willReturn((Object)scope);
        this.listener.afterTestMethod(this.mockTestContext);
        ((TestContext)Mockito.verify((Object)this.mockTestContext)).getApplicationContext();
        ((ConfigurableApplicationContext)Mockito.verify((Object)this.mockConfigurableContext)).getBeanFactory();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockConfigurableContext, this.mockApplicationContext, this.mockTestContext});
    }

    @Test
    public void shouldSetReinjectDepedenciesAttributeWhenScopeIsDisposed() {
        WebDeviceScope scope = new WebDeviceScope();
        scope.get("prototype", () -> Mockito.mock(WebDevice.class));
        BDDMockito.given((Object)this.mockTestContext.getApplicationContext()).willReturn((Object)this.mockConfigurableContext);
        BDDMockito.given((Object)this.mockConfigurableContext.getBeanFactory()).willReturn((Object)this.mockBeanFactory);
        BDDMockito.given((Object)this.mockBeanFactory.getRegisteredScope("webdevice")).willReturn((Object)scope);
        this.listener.afterTestMethod(this.mockTestContext);
        ((TestContext)Mockito.verify((Object)this.mockTestContext)).getApplicationContext();
        ((ConfigurableApplicationContext)Mockito.verify((Object)this.mockConfigurableContext)).getBeanFactory();
        ((TestContext)Mockito.verify((Object)this.mockTestContext)).setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, (Object)Boolean.TRUE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockConfigurableContext, this.mockApplicationContext, this.mockTestContext});
    }
}

