/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.support;

import io.webdevice.device.Device;
import io.webdevice.device.DeviceNotProvidedException;
import io.webdevice.device.DeviceProvider;
import io.webdevice.device.DeviceRegistry;
import org.openqa.selenium.WebDriver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpringDeviceRegistry
implements DeviceRegistry {
    private final BeanFactory factory;

    @Autowired
    public SpringDeviceRegistry(BeanFactory factory) {
        this.factory = factory;
    }

    public <Driver extends WebDriver> Device<Driver> provide(String device) {
        DeviceProvider<Driver> provider = this.providerOf(device);
        return (Device)provider.get();
    }

    public <Driver extends WebDriver> void release(Device<Driver> device) {
        DeviceProvider<Driver> provider = this.providerOf(device.getName());
        provider.accept(device);
    }

    private <Driver extends WebDriver> DeviceProvider<Driver> providerOf(String device) {
        try {
            return (DeviceProvider)this.factory.getBean(device, DeviceProvider.class);
        }
        catch (BeansException e) {
            throw new DeviceNotProvidedException(device, (Throwable)e);
        }
    }
}

