/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.WebDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class WebDeviceScope
implements Scope {
    public static final String NAME = "webdevice";
    private final Map<String, List<Object>> instances = new LinkedHashMap<String, List<Object>>();

    public boolean isEmpty() {
        return this.instances.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory<?> objectFactory) {
        Map<String, List<Object>> map = this.instances;
        synchronized (map) {
            Object instance = objectFactory.getObject();
            this.instances.computeIfAbsent(name, s -> new ArrayList()).add(instance);
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name) {
        Map<String, List<Object>> map = this.instances;
        synchronized (map) {
            return this.instances.remove(name);
        }
    }

    public void registerDestructionCallback(String name, Runnable callback) {
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispose() {
        AtomicBoolean disposed = new AtomicBoolean(false);
        Map<String, List<Object>> map = this.instances;
        synchronized (map) {
            this.instances.values().stream().flatMap(Collection::stream).filter(instance -> {
                if (instance instanceof WebDevice) {
                    disposed.set(true);
                    return true;
                }
                return false;
            }).map(instance -> (WebDevice)instance).forEach(WebDevice::release);
            this.instances.clear();
        }
        return disposed.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebDeviceScope scope = (WebDeviceScope)o;
        return Objects.equals(this.instances, scope.instances);
    }

    public int hashCode() {
        return Objects.hash(this.instances);
    }

    public static String namespace(String name, Object ... args) {
        return String.format("%s.%s", NAME, String.format(name, args));
    }

    public static WebDeviceScope registerScope(ConfigurableListableBeanFactory registry) {
        WebDeviceScope scope = new WebDeviceScope();
        registry.registerScope(NAME, (Scope)scope);
        return scope;
    }

    public static WebDeviceScope scope(ApplicationContext context) {
        if (context instanceof ConfigurableApplicationContext) {
            return (WebDeviceScope)((ConfigurableApplicationContext)context).getBeanFactory().getRegisteredScope(NAME);
        }
        return null;
    }
}

