/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.interceptors;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.jdbc.Statement;
import com.mysql.cj.api.jdbc.interceptors.StatementInterceptor;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.api.mysqla.result.Resultset;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResultSetScannerInterceptor
implements StatementInterceptor {
    protected Pattern regexP;

    @Override
    public StatementInterceptor init(MysqlConnection conn, Properties props, Log log) {
        String regexFromUser = props.getProperty("resultSetScannerRegex");
        if (regexFromUser == null || regexFromUser.length() == 0) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ResultSetScannerInterceptor.0"));
        }
        try {
            this.regexP = Pattern.compile(regexFromUser);
        }
        catch (Throwable t) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ResultSetScannerInterceptor.1"), t);
        }
        return this;
    }

    @Override
    public <T extends Resultset> T postProcess(String sql, Statement interceptedStatement, T originalResultSet, int warningCount, boolean noIndexUsed, boolean noGoodIndexUsed, Exception statementException) throws SQLException {
        final T finalResultSet = originalResultSet;
        return (T)((Resultset)Proxy.newProxyInstance(originalResultSet.getClass().getClassLoader(), new Class[]{Resultset.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Matcher matcher;
                Object invocationResult = method.invoke((Object)finalResultSet, args);
                String methodName = method.getName();
                if ((invocationResult != null && invocationResult instanceof String || "getString".equals(methodName) || "getObject".equals(methodName) || "getObjectStoredProc".equals(methodName)) && (matcher = ResultSetScannerInterceptor.this.regexP.matcher(invocationResult.toString())).matches()) {
                    throw new SQLException(Messages.getString("ResultSetScannerInterceptor.2"));
                }
                return invocationResult;
            }
        }));
    }

    @Override
    public <T extends Resultset> T preProcess(String sql, Statement interceptedStatement) throws SQLException {
        return null;
    }

    @Override
    public boolean executeTopLevelOnly() {
        return false;
    }

    @Override
    public void destroy() {
    }
}

