/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.io;

import java.io.IOException;
import java.io.Writer;
import net.arnx.jsonic.io.OutputSource;

public class WriterOutputSource
implements OutputSource {
    private final Writer writer;
    private final char[] buf = new char[1024];
    private int pos = 0;

    public WriterOutputSource(Writer writer) {
        this.writer = writer;
    }

    public void append(String string) throws IOException {
        this.append(string, 0, string.length());
    }

    public void append(String string, int n, int n2) throws IOException {
        int n3 = n2 - n;
        if (this.pos + n3 < this.buf.length) {
            string.getChars(n, n2, this.buf, this.pos);
            this.pos += n3;
            return;
        }
        if (this.pos > 0) {
            this.writer.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
        if (n3 < this.buf.length) {
            string.getChars(n, n2, this.buf, 0);
            this.pos = n3;
        } else {
            this.writer.write(string, n, n3);
        }
    }

    public void append(char c) throws IOException {
        if (this.pos + 1 >= this.buf.length) {
            this.writer.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
        this.buf[this.pos++] = c;
    }

    public void flush() throws IOException {
        if (this.pos > 0) {
            this.writer.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
        this.writer.flush();
    }
}

