/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.utility.privilege.SetAccessibleAction;

public interface LoadedTypeInitializer {
    public void onLoad(Class<?> var1);

    public boolean isAlive();

    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Serialization is considered opt-in for a rare use case")
    public static class Compound
    implements LoadedTypeInitializer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<LoadedTypeInitializer> loadedTypeInitializers = new ArrayList<LoadedTypeInitializer>();

        public Compound(LoadedTypeInitializer ... loadedTypeInitializer) {
            this(Arrays.asList(loadedTypeInitializer));
        }

        public Compound(List<? extends LoadedTypeInitializer> loadedTypeInitializers) {
            for (LoadedTypeInitializer loadedTypeInitializer : loadedTypeInitializers) {
                if (loadedTypeInitializer instanceof Compound) {
                    this.loadedTypeInitializers.addAll(((Compound)loadedTypeInitializer).loadedTypeInitializers);
                    continue;
                }
                if (loadedTypeInitializer instanceof NoOp) continue;
                this.loadedTypeInitializers.add(loadedTypeInitializer);
            }
        }

        @Override
        public void onLoad(Class<?> type) {
            for (LoadedTypeInitializer loadedTypeInitializer : this.loadedTypeInitializers) {
                loadedTypeInitializer.onLoad(type);
            }
        }

        @Override
        public boolean isAlive() {
            for (LoadedTypeInitializer loadedTypeInitializer : this.loadedTypeInitializers) {
                if (!loadedTypeInitializer.isAlive()) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Compound)) {
                return false;
            }
            Compound other = (Compound)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<LoadedTypeInitializer> this$loadedTypeInitializers = this.loadedTypeInitializers;
            List<LoadedTypeInitializer> other$loadedTypeInitializers = other.loadedTypeInitializers;
            return !(this$loadedTypeInitializers == null ? other$loadedTypeInitializers != null : !((Object)this$loadedTypeInitializers).equals(other$loadedTypeInitializers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Compound;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<LoadedTypeInitializer> $loadedTypeInitializers = this.loadedTypeInitializers;
            result = result * 59 + ($loadedTypeInitializers == null ? 43 : ((Object)$loadedTypeInitializers).hashCode());
            return result;
        }
    }

    public static class ForStaticField
    implements LoadedTypeInitializer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Object STATIC_FIELD = null;
        private final String fieldName;
        private final Object value;

        protected ForStaticField(String fieldName, Object value) {
            this.fieldName = fieldName;
            this.value = value;
        }

        @Override
        public void onLoad(Class<?> type) {
            try {
                Field field = type.getDeclaredField(this.fieldName);
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
                    AccessController.doPrivileged(new SetAccessibleAction<Field>(field));
                }
                field.set(STATIC_FIELD, this.value);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalArgumentException("Cannot access " + this.fieldName + " from " + type, exception);
            }
            catch (NoSuchFieldException exception) {
                throw new IllegalStateException("There is no field " + this.fieldName + " defined on " + type, exception);
            }
        }

        @Override
        public boolean isAlive() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForStaticField)) {
                return false;
            }
            ForStaticField other = (ForStaticField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fieldName = this.fieldName;
            String other$fieldName = other.fieldName;
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            Object this$value = this.value;
            Object other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForStaticField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fieldName = this.fieldName;
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            Object $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    public static enum NoOp implements LoadedTypeInitializer
    {
        INSTANCE;


        @Override
        public void onLoad(Class<?> type) {
        }

        @Override
        public boolean isAlive() {
            return false;
        }
    }
}

