/*
 * Decompiled with CFR 0.152.
 */
package net.commuty.parking.http;

import net.commuty.parking.http.ApiException;
import net.commuty.parking.http.Error;

public class HttpRequestException
extends ApiException {
    private final int httpResponseCode;
    private final Error errorResponse;

    protected HttpRequestException(int httpResponseCode, Error errorResponse) {
        super("The request failed with an error code " + httpResponseCode);
        this.httpResponseCode = httpResponseCode;
        this.errorResponse = errorResponse;
    }

    public Error getErrorResponse() {
        return this.errorResponse;
    }

    public boolean isForbidden() {
        return this.httpResponseCode == 403;
    }

    public boolean isUnauthorized() {
        return this.httpResponseCode == 401;
    }

    public boolean isBadRequest() {
        return this.httpResponseCode == 400;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }
}

