/*
 * Decompiled with CFR 0.152.
 */
package net.commuty.parking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import net.commuty.parking.model.AccessDirection;
import net.commuty.parking.model.UserId;
import net.commuty.parking.model.UserIdType;

public class AccessLog {
    private final String userId;
    private final UserIdType userIdType;
    private final AccessDirection way;
    private final LocalDateTime at;
    private final boolean granted;
    private final String reason;

    @JsonCreator
    AccessLog(@JsonProperty(value="userId") String userId, @JsonProperty(value="userIdType") UserIdType userIdType, @JsonProperty(value="way") AccessDirection way, @JsonProperty(value="at") LocalDateTime at, @JsonProperty(value="granted") boolean granted, @JsonProperty(value="reason") String reason) {
        if (at == null) {
            throw new IllegalArgumentException("Log date cannot be null");
        }
        this.userId = userId;
        this.userIdType = userIdType;
        this.way = way;
        this.at = at;
        this.granted = granted;
        this.reason = reason;
    }

    AccessLog(String userId, UserIdType userIdType, AccessDirection way, LocalDateTime at) {
        this(userId, userIdType, way, at, true, null);
    }

    public static AccessLog createInAccessLog(UserId userId, LocalDateTime at) {
        return AccessLog.createInAccessLog(userId, at, true, null);
    }

    public static AccessLog createOutAccessLog(UserId userId, LocalDateTime at) {
        return AccessLog.createOutAccessLog(userId, at, true, null);
    }

    public static AccessLog createInAccessLog(UserId userId, LocalDateTime at, boolean granted, String reason) {
        if (userId == null) {
            throw new IllegalArgumentException("UserId cannot be null");
        }
        return new AccessLog(userId.getId(), userId.getType(), AccessDirection.IN, at, granted, reason);
    }

    public static AccessLog createOutAccessLog(UserId userId, LocalDateTime at, boolean granted, String reason) {
        if (userId == null) {
            throw new IllegalArgumentException("UserId cannot be null");
        }
        return new AccessLog(userId.getId(), userId.getType(), AccessDirection.OUT, at, granted, reason);
    }

    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userIdType")
    public UserIdType getUserIdType() {
        return this.userIdType;
    }

    @JsonProperty(value="way")
    public AccessDirection getWay() {
        return this.way;
    }

    @JsonProperty(value="at")
    public LocalDateTime getAt() {
        return this.at;
    }

    @JsonProperty(value="granted")
    public boolean isGranted() {
        return this.granted;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }
}

