/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;

public class FormatUtils {
    private static final double LOG_10 = Math.log(10.0);

    private FormatUtils() {
    }

    public static void appendPaddedInteger(StringBuffer buf, int value, int size) {
        if (value < 0) {
            buf.append('-');
            if (value != Integer.MIN_VALUE) {
                value = -value;
            } else {
                while (size > 10) {
                    buf.append('0');
                    --size;
                }
                buf.append("2147483648");
                return;
            }
        }
        if (value < 10) {
            while (size > 1) {
                buf.append('0');
                --size;
            }
            buf.append((char)(value + 48));
        } else if (value < 100) {
            while (size > 2) {
                buf.append('0');
                --size;
            }
            int d = (value + 1) * 0xCCCCCC >> 27;
            buf.append((char)(d + 48));
            buf.append((char)(value - (d << 3) - (d << 1) + 48));
        } else {
            int digits = value < 1000 ? 3 : (value < 10000 ? 4 : (int)(Math.log(value) / LOG_10) + 1);
            while (size > digits) {
                buf.append('0');
                --size;
            }
            buf.append(Integer.toString(value));
        }
    }

    public static void appendPaddedInteger(StringBuffer buf, long value, int size) {
        int intValue = (int)value;
        if ((long)intValue == value) {
            FormatUtils.appendPaddedInteger(buf, intValue, size);
        } else if (size <= 19) {
            buf.append(Long.toString(value));
        } else {
            if (value < 0L) {
                buf.append('-');
                if (value != Long.MIN_VALUE) {
                    value = -value;
                } else {
                    while (size > 19) {
                        buf.append('0');
                        --size;
                    }
                    buf.append("9223372036854775808");
                    return;
                }
            }
            int digits = (int)(Math.log(value) / LOG_10) + 1;
            while (size > digits) {
                buf.append('0');
                --size;
            }
            buf.append(Long.toString(value));
        }
    }

    public static void writePaddedInteger(Writer out, int value, int size) throws IOException {
        if (value < 0) {
            out.write(45);
            if (value != Integer.MIN_VALUE) {
                value = -value;
            } else {
                while (size > 10) {
                    out.write(48);
                    --size;
                }
                out.write("2147483648");
                return;
            }
        }
        if (value < 10) {
            while (size > 1) {
                out.write(48);
                --size;
            }
            out.write(value + 48);
        } else if (value < 100) {
            while (size > 2) {
                out.write(48);
                --size;
            }
            int d = (value + 1) * 0xCCCCCC >> 27;
            out.write(d + 48);
            out.write(value - (d << 3) - (d << 1) + 48);
        } else {
            int digits = value < 1000 ? 3 : (value < 10000 ? 4 : (int)(Math.log(value) / LOG_10) + 1);
            while (size > digits) {
                out.write(48);
                --size;
            }
            out.write(Integer.toString(value));
        }
    }

    public static void writePaddedInteger(Writer out, long value, int size) throws IOException {
        int intValue = (int)value;
        if ((long)intValue == value) {
            FormatUtils.writePaddedInteger(out, intValue, size);
        } else if (size <= 19) {
            out.write(Long.toString(value));
        } else {
            if (value < 0L) {
                out.write(45);
                if (value != Long.MIN_VALUE) {
                    value = -value;
                } else {
                    while (size > 19) {
                        out.write(48);
                        --size;
                    }
                    out.write("9223372036854775808");
                    return;
                }
            }
            int digits = (int)(Math.log(value) / LOG_10) + 1;
            while (size > digits) {
                out.write(48);
                --size;
            }
            out.write(Long.toString(value));
        }
    }

    public static void appendUnpaddedInteger(StringBuffer buf, int value) {
        if (value < 0) {
            buf.append('-');
            if (value != Integer.MIN_VALUE) {
                value = -value;
            } else {
                buf.append("2147483648");
                return;
            }
        }
        if (value < 10) {
            buf.append((char)(value + 48));
        } else if (value < 100) {
            int d = (value + 1) * 0xCCCCCC >> 27;
            buf.append((char)(d + 48));
            buf.append((char)(value - (d << 3) - (d << 1) + 48));
        } else {
            buf.append(Integer.toString(value));
        }
    }

    public static void appendUnpaddedInteger(StringBuffer buf, long value) {
        int intValue = (int)value;
        if ((long)intValue == value) {
            FormatUtils.appendUnpaddedInteger(buf, intValue);
        } else {
            buf.append(Long.toString(value));
        }
    }

    public static void writeUnpaddedInteger(Writer out, int value) throws IOException {
        if (value < 0) {
            out.write(45);
            if (value != Integer.MIN_VALUE) {
                value = -value;
            } else {
                out.write("2147483648");
                return;
            }
        }
        if (value < 10) {
            out.write(value + 48);
        } else if (value < 100) {
            int d = (value + 1) * 0xCCCCCC >> 27;
            out.write(d + 48);
            out.write(value - (d << 3) - (d << 1) + 48);
        } else {
            out.write(Integer.toString(value));
        }
    }

    public static void writeUnpaddedInteger(Writer out, long value) throws IOException {
        int intValue = (int)value;
        if ((long)intValue == value) {
            FormatUtils.writeUnpaddedInteger(out, intValue);
        } else {
            out.write(Long.toString(value));
        }
    }

    public static int calculateDigitCount(long value) {
        if (value < 0L) {
            if (value != Long.MIN_VALUE) {
                return FormatUtils.calculateDigitCount(-value) + 1;
            }
            return 20;
        }
        return value < 10L ? 1 : (value < 100L ? 2 : (value < 1000L ? 3 : (value < 10000L ? 4 : (int)(Math.log(value) / LOG_10) + 1)));
    }

    static int parseTwoDigits(String text, int position) {
        int value = text.charAt(position) - 48;
        return (value << 3) + (value << 1) + text.charAt(position + 1) - 48;
    }

    static String createErrorMessage(String text, int errorPos) {
        int sampleLen = errorPos + 32;
        String sampleText = text.length() <= sampleLen + 3 ? text : text.substring(0, sampleLen).concat("...");
        if (errorPos <= 0) {
            return "Invalid format: \"" + sampleText + '\"';
        }
        if (errorPos >= text.length()) {
            return "Invalid format: \"" + sampleText + "\" is too short";
        }
        return "Invalid format: \"" + sampleText + "\" is malformed at \"" + sampleText.substring(errorPos) + '\"';
    }
}

