/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadWritableInstant;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.FormatUtils;

public class DateTimeFormatter {
    private final DateTimePrinter iPrinter;
    private final DateTimeParser iParser;
    private final Locale iLocale;
    private final boolean iOffsetParsed;
    private final Chronology iChrono;
    private final DateTimeZone iZone;
    private final Integer iPivotYear;
    private final int iDefaultYear;

    public DateTimeFormatter(DateTimePrinter printer, DateTimeParser parser) {
        this.iPrinter = printer;
        this.iParser = parser;
        this.iLocale = null;
        this.iOffsetParsed = false;
        this.iChrono = null;
        this.iZone = null;
        this.iPivotYear = null;
        this.iDefaultYear = 2000;
    }

    private DateTimeFormatter(DateTimePrinter printer, DateTimeParser parser, Locale locale, boolean offsetParsed, Chronology chrono, DateTimeZone zone, Integer pivotYear, int defaultYear) {
        this.iPrinter = printer;
        this.iParser = parser;
        this.iLocale = locale;
        this.iOffsetParsed = offsetParsed;
        this.iChrono = chrono;
        this.iZone = zone;
        this.iPivotYear = pivotYear;
        this.iDefaultYear = defaultYear;
    }

    public boolean isPrinter() {
        return this.iPrinter != null;
    }

    public DateTimePrinter getPrinter() {
        return this.iPrinter;
    }

    public boolean isParser() {
        return this.iParser != null;
    }

    public DateTimeParser getParser() {
        return this.iParser;
    }

    public DateTimeFormatter withLocale(Locale locale) {
        if (locale == this.getLocale() || locale != null && locale.equals(this.getLocale())) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, locale, this.iOffsetParsed, this.iChrono, this.iZone, this.iPivotYear, this.iDefaultYear);
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public DateTimeFormatter withOffsetParsed() {
        if (this.iOffsetParsed) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, true, this.iChrono, null, this.iPivotYear, this.iDefaultYear);
    }

    public boolean isOffsetParsed() {
        return this.iOffsetParsed;
    }

    public DateTimeFormatter withChronology(Chronology chrono) {
        if (this.iChrono == chrono) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, chrono, this.iZone, this.iPivotYear, this.iDefaultYear);
    }

    public Chronology getChronology() {
        return this.iChrono;
    }

    @Deprecated
    public Chronology getChronolgy() {
        return this.iChrono;
    }

    public DateTimeFormatter withZoneUTC() {
        return this.withZone(DateTimeZone.UTC);
    }

    public DateTimeFormatter withZone(DateTimeZone zone) {
        if (this.iZone == zone) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, false, this.iChrono, zone, this.iPivotYear, this.iDefaultYear);
    }

    public DateTimeZone getZone() {
        return this.iZone;
    }

    public DateTimeFormatter withPivotYear(Integer pivotYear) {
        if (this.iPivotYear == pivotYear || this.iPivotYear != null && this.iPivotYear.equals(pivotYear)) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, this.iChrono, this.iZone, pivotYear, this.iDefaultYear);
    }

    public DateTimeFormatter withPivotYear(int pivotYear) {
        return this.withPivotYear((Integer)pivotYear);
    }

    public Integer getPivotYear() {
        return this.iPivotYear;
    }

    public DateTimeFormatter withDefaultYear(int defaultYear) {
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, this.iChrono, this.iZone, this.iPivotYear, defaultYear);
    }

    public int getDefaultYear() {
        return this.iDefaultYear;
    }

    public void printTo(StringBuffer buf, ReadableInstant instant) {
        long millis = DateTimeUtils.getInstantMillis(instant);
        Chronology chrono = DateTimeUtils.getInstantChronology(instant);
        this.printTo(buf, millis, chrono);
    }

    public void printTo(Writer out, ReadableInstant instant) throws IOException {
        long millis = DateTimeUtils.getInstantMillis(instant);
        Chronology chrono = DateTimeUtils.getInstantChronology(instant);
        this.printTo(out, millis, chrono);
    }

    public void printTo(Appendable appendable, ReadableInstant instant) throws IOException {
        appendable.append(this.print(instant));
    }

    public void printTo(StringBuffer buf, long instant) {
        this.printTo(buf, instant, null);
    }

    public void printTo(Writer out, long instant) throws IOException {
        this.printTo(out, instant, null);
    }

    public void printTo(Appendable appendable, long instant) throws IOException {
        appendable.append(this.print(instant));
    }

    public void printTo(StringBuffer buf, ReadablePartial partial) {
        DateTimePrinter printer = this.requirePrinter();
        if (partial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        printer.printTo(buf, partial, this.iLocale);
    }

    public void printTo(Writer out, ReadablePartial partial) throws IOException {
        DateTimePrinter printer = this.requirePrinter();
        if (partial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        printer.printTo(out, partial, this.iLocale);
    }

    public void printTo(Appendable appendable, ReadablePartial partial) throws IOException {
        appendable.append(this.print(partial));
    }

    public String print(ReadableInstant instant) {
        StringBuffer buf = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(buf, instant);
        return buf.toString();
    }

    public String print(long instant) {
        StringBuffer buf = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(buf, instant);
        return buf.toString();
    }

    public String print(ReadablePartial partial) {
        StringBuffer buf = new StringBuffer(this.requirePrinter().estimatePrintedLength());
        this.printTo(buf, partial);
        return buf.toString();
    }

    private void printTo(StringBuffer buf, long instant, Chronology chrono) {
        DateTimePrinter printer = this.requirePrinter();
        DateTimeZone zone = (chrono = this.selectChronology(chrono)).getZone();
        int offset = zone.getOffset(instant);
        long adjustedInstant = instant + (long)offset;
        if ((instant ^ adjustedInstant) < 0L && (instant ^ (long)offset) >= 0L) {
            zone = DateTimeZone.UTC;
            offset = 0;
            adjustedInstant = instant;
        }
        printer.printTo(buf, adjustedInstant, chrono.withUTC(), offset, zone, this.iLocale);
    }

    private void printTo(Writer buf, long instant, Chronology chrono) throws IOException {
        DateTimePrinter printer = this.requirePrinter();
        DateTimeZone zone = (chrono = this.selectChronology(chrono)).getZone();
        int offset = zone.getOffset(instant);
        long adjustedInstant = instant + (long)offset;
        if ((instant ^ adjustedInstant) < 0L && (instant ^ (long)offset) >= 0L) {
            zone = DateTimeZone.UTC;
            offset = 0;
            adjustedInstant = instant;
        }
        printer.printTo(buf, adjustedInstant, chrono.withUTC(), offset, zone, this.iLocale);
    }

    private DateTimePrinter requirePrinter() {
        DateTimePrinter printer = this.iPrinter;
        if (printer == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
        return printer;
    }

    public int parseInto(ReadWritableInstant instant, String text, int position) {
        DateTimeParser parser = this.requireParser();
        if (instant == null) {
            throw new IllegalArgumentException("Instant must not be null");
        }
        long instantMillis = instant.getMillis();
        Chronology chrono = instant.getChronology();
        int defaultYear = DateTimeUtils.getChronology(chrono).year().get(instantMillis);
        long instantLocal = instantMillis + (long)chrono.getZone().getOffset(instantMillis);
        chrono = this.selectChronology(chrono);
        DateTimeParserBucket bucket = new DateTimeParserBucket(instantLocal, chrono, this.iLocale, this.iPivotYear, defaultYear);
        int newPos = parser.parseInto(bucket, text, position);
        instant.setMillis(bucket.computeMillis(false, text));
        if (this.iOffsetParsed && bucket.getOffsetInteger() != null) {
            int parsedOffset = bucket.getOffsetInteger();
            DateTimeZone parsedZone = DateTimeZone.forOffsetMillis(parsedOffset);
            chrono = chrono.withZone(parsedZone);
        } else if (bucket.getZone() != null) {
            chrono = chrono.withZone(bucket.getZone());
        }
        instant.setChronology(chrono);
        if (this.iZone != null) {
            instant.setZone(this.iZone);
        }
        return newPos;
    }

    public long parseMillis(String text) {
        Chronology chrono;
        DateTimeParserBucket bucket;
        DateTimeParser parser = this.requireParser();
        int newPos = parser.parseInto(bucket = new DateTimeParserBucket(0L, chrono = this.selectChronology(this.iChrono), this.iLocale, this.iPivotYear, this.iDefaultYear), text, 0);
        if (newPos >= 0) {
            if (newPos >= text.length()) {
                return bucket.computeMillis(true, text);
            }
        } else {
            newPos ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(text, newPos));
    }

    public LocalDate parseLocalDate(String text) {
        return this.parseLocalDateTime(text).toLocalDate();
    }

    public LocalTime parseLocalTime(String text) {
        return this.parseLocalDateTime(text).toLocalTime();
    }

    public LocalDateTime parseLocalDateTime(String text) {
        Chronology chrono;
        DateTimeParserBucket bucket;
        DateTimeParser parser = this.requireParser();
        int newPos = parser.parseInto(bucket = new DateTimeParserBucket(0L, chrono = this.selectChronology(null).withUTC(), this.iLocale, this.iPivotYear, this.iDefaultYear), text, 0);
        if (newPos >= 0) {
            if (newPos >= text.length()) {
                long millis = bucket.computeMillis(true, text);
                if (bucket.getOffsetInteger() != null) {
                    int parsedOffset = bucket.getOffsetInteger();
                    DateTimeZone parsedZone = DateTimeZone.forOffsetMillis(parsedOffset);
                    chrono = chrono.withZone(parsedZone);
                } else if (bucket.getZone() != null) {
                    chrono = chrono.withZone(bucket.getZone());
                }
                return new LocalDateTime(millis, chrono);
            }
        } else {
            newPos ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(text, newPos));
    }

    public DateTime parseDateTime(String text) {
        Chronology chrono;
        DateTimeParserBucket bucket;
        DateTimeParser parser = this.requireParser();
        int newPos = parser.parseInto(bucket = new DateTimeParserBucket(0L, chrono = this.selectChronology(null), this.iLocale, this.iPivotYear, this.iDefaultYear), text, 0);
        if (newPos >= 0) {
            if (newPos >= text.length()) {
                long millis = bucket.computeMillis(true, text);
                if (this.iOffsetParsed && bucket.getOffsetInteger() != null) {
                    int parsedOffset = bucket.getOffsetInteger();
                    DateTimeZone parsedZone = DateTimeZone.forOffsetMillis(parsedOffset);
                    chrono = chrono.withZone(parsedZone);
                } else if (bucket.getZone() != null) {
                    chrono = chrono.withZone(bucket.getZone());
                }
                DateTime dt = new DateTime(millis, chrono);
                if (this.iZone != null) {
                    dt = dt.withZone(this.iZone);
                }
                return dt;
            }
        } else {
            newPos ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(text, newPos));
    }

    public MutableDateTime parseMutableDateTime(String text) {
        Chronology chrono;
        DateTimeParserBucket bucket;
        DateTimeParser parser = this.requireParser();
        int newPos = parser.parseInto(bucket = new DateTimeParserBucket(0L, chrono = this.selectChronology(null), this.iLocale, this.iPivotYear, this.iDefaultYear), text, 0);
        if (newPos >= 0) {
            if (newPos >= text.length()) {
                long millis = bucket.computeMillis(true, text);
                if (this.iOffsetParsed && bucket.getOffsetInteger() != null) {
                    int parsedOffset = bucket.getOffsetInteger();
                    DateTimeZone parsedZone = DateTimeZone.forOffsetMillis(parsedOffset);
                    chrono = chrono.withZone(parsedZone);
                } else if (bucket.getZone() != null) {
                    chrono = chrono.withZone(bucket.getZone());
                }
                MutableDateTime dt = new MutableDateTime(millis, chrono);
                if (this.iZone != null) {
                    dt.setZone(this.iZone);
                }
                return dt;
            }
        } else {
            newPos ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(text, newPos));
    }

    private DateTimeParser requireParser() {
        DateTimeParser parser = this.iParser;
        if (parser == null) {
            throw new UnsupportedOperationException("Parsing not supported");
        }
        return parser;
    }

    private Chronology selectChronology(Chronology chrono) {
        chrono = DateTimeUtils.getChronology(chrono);
        if (this.iChrono != null) {
            chrono = this.iChrono;
        }
        if (this.iZone != null) {
            chrono = chrono.withZone(this.iZone);
        }
        return chrono;
    }
}

