/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.lang.ref.WeakReference;
import java.text.DateFormatSymbols;
import java.util.Locale;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.IllegalFieldValueException;

class GJLocaleSymbols {
    private static final int FAST_CACHE_SIZE = 64;
    private static final GJLocaleSymbols[] cFastCache = new GJLocaleSymbols[64];
    private static WeakHashMap<Locale, GJLocaleSymbols> cCache = new WeakHashMap();
    private final WeakReference<Locale> iLocale;
    private final String[] iEras;
    private final String[] iDaysOfWeek;
    private final String[] iShortDaysOfWeek;
    private final String[] iMonths;
    private final String[] iShortMonths;
    private final String[] iHalfday;
    private final TreeMap<String, Integer> iParseEras;
    private final TreeMap<String, Integer> iParseDaysOfWeek;
    private final TreeMap<String, Integer> iParseMonths;
    private final int iMaxEraLength;
    private final int iMaxDayOfWeekLength;
    private final int iMaxShortDayOfWeekLength;
    private final int iMaxMonthLength;
    private final int iMaxShortMonthLength;
    private final int iMaxHalfdayLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GJLocaleSymbols forLocale(Locale locale) {
        int index;
        GJLocaleSymbols symbols;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((symbols = cFastCache[index = System.identityHashCode(locale) & 0x3F]) != null && symbols.iLocale.get() == locale) {
            return symbols;
        }
        WeakHashMap<Locale, GJLocaleSymbols> weakHashMap = cCache;
        synchronized (weakHashMap) {
            symbols = cCache.get(locale);
            if (symbols == null) {
                symbols = new GJLocaleSymbols(locale);
                cCache.put(locale, symbols);
            }
        }
        GJLocaleSymbols.cFastCache[index] = symbols;
        return symbols;
    }

    private static String[] realignMonths(String[] months) {
        String[] a = new String[13];
        for (int i = 1; i < 13; ++i) {
            a[i] = months[i - 1];
        }
        return a;
    }

    private static String[] realignDaysOfWeek(String[] daysOfWeek) {
        String[] a = new String[8];
        for (int i = 1; i < 8; ++i) {
            a[i] = daysOfWeek[i < 7 ? i + 1 : 1];
        }
        return a;
    }

    private static void addSymbols(TreeMap<String, Integer> map, String[] symbols, Integer[] integers) {
        int i = symbols.length;
        while (--i >= 0) {
            String symbol = symbols[i];
            if (symbol == null) continue;
            map.put(symbol, integers[i]);
        }
    }

    private static void addNumerals(TreeMap<String, Integer> map, int start, int end, Integer[] integers) {
        for (int i = start; i <= end; ++i) {
            map.put(String.valueOf(i).intern(), integers[i]);
        }
    }

    private static int maxLength(String[] a) {
        int max = 0;
        int i = a.length;
        while (--i >= 0) {
            int len;
            String s = a[i];
            if (s == null || (len = s.length()) <= max) continue;
            max = len;
        }
        return max;
    }

    private GJLocaleSymbols(Locale locale) {
        this.iLocale = new WeakReference<Locale>(locale);
        DateFormatSymbols dfs = DateTimeUtils.getDateFormatSymbols(locale);
        this.iEras = dfs.getEras();
        this.iDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(dfs.getWeekdays());
        this.iShortDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(dfs.getShortWeekdays());
        this.iMonths = GJLocaleSymbols.realignMonths(dfs.getMonths());
        this.iShortMonths = GJLocaleSymbols.realignMonths(dfs.getShortMonths());
        this.iHalfday = dfs.getAmPmStrings();
        Integer[] integers = new Integer[13];
        for (int i = 0; i < 13; ++i) {
            integers[i] = i;
        }
        this.iParseEras = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseEras, this.iEras, integers);
        if ("en".equals(locale.getLanguage())) {
            this.iParseEras.put("BCE", integers[0]);
            this.iParseEras.put("CE", integers[1]);
        }
        this.iParseDaysOfWeek = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseDaysOfWeek, this.iDaysOfWeek, integers);
        GJLocaleSymbols.addSymbols(this.iParseDaysOfWeek, this.iShortDaysOfWeek, integers);
        GJLocaleSymbols.addNumerals(this.iParseDaysOfWeek, 1, 7, integers);
        this.iParseMonths = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseMonths, this.iMonths, integers);
        GJLocaleSymbols.addSymbols(this.iParseMonths, this.iShortMonths, integers);
        GJLocaleSymbols.addNumerals(this.iParseMonths, 1, 12, integers);
        this.iMaxEraLength = GJLocaleSymbols.maxLength(this.iEras);
        this.iMaxDayOfWeekLength = GJLocaleSymbols.maxLength(this.iDaysOfWeek);
        this.iMaxShortDayOfWeekLength = GJLocaleSymbols.maxLength(this.iShortDaysOfWeek);
        this.iMaxMonthLength = GJLocaleSymbols.maxLength(this.iMonths);
        this.iMaxShortMonthLength = GJLocaleSymbols.maxLength(this.iShortMonths);
        this.iMaxHalfdayLength = GJLocaleSymbols.maxLength(this.iHalfday);
    }

    public String eraValueToText(int value) {
        return this.iEras[value];
    }

    public int eraTextToValue(String text) {
        Integer era = this.iParseEras.get(text);
        if (era != null) {
            return era;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.era(), text);
    }

    public int getEraMaxTextLength() {
        return this.iMaxEraLength;
    }

    public String monthOfYearValueToText(int value) {
        return this.iMonths[value];
    }

    public String monthOfYearValueToShortText(int value) {
        return this.iShortMonths[value];
    }

    public int monthOfYearTextToValue(String text) {
        Integer month = this.iParseMonths.get(text);
        if (month != null) {
            return month;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.monthOfYear(), text);
    }

    public int getMonthMaxTextLength() {
        return this.iMaxMonthLength;
    }

    public int getMonthMaxShortTextLength() {
        return this.iMaxShortMonthLength;
    }

    public String dayOfWeekValueToText(int value) {
        return this.iDaysOfWeek[value];
    }

    public String dayOfWeekValueToShortText(int value) {
        return this.iShortDaysOfWeek[value];
    }

    public int dayOfWeekTextToValue(String text) {
        Integer day = this.iParseDaysOfWeek.get(text);
        if (day != null) {
            return day;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.dayOfWeek(), text);
    }

    public int getDayOfWeekMaxTextLength() {
        return this.iMaxDayOfWeekLength;
    }

    public int getDayOfWeekMaxShortTextLength() {
        return this.iMaxShortDayOfWeekLength;
    }

    public String halfdayValueToText(int value) {
        return this.iHalfday[value];
    }

    public int halfdayTextToValue(String text) {
        String[] halfday = this.iHalfday;
        int i = halfday.length;
        while (--i >= 0) {
            if (!halfday[i].equalsIgnoreCase(text)) continue;
            return i;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.halfdayOfDay(), text);
    }

    public int getHalfdayMaxTextLength() {
        return this.iMaxHalfdayLength;
    }
}

