/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.DatatypeConverter;
import org.joda.convert.StringConverter;

enum JDKStringConverter implements StringConverter<Object>
{
    STRING((Class)String.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return str;
        }
    }
    ,
    CHAR_SEQUENCE((Class)CharSequence.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return str;
        }
    }
    ,
    STRING_BUFFER((Class)StringBuffer.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new StringBuffer(str);
        }
    }
    ,
    STRING_BUILDER((Class)StringBuilder.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new StringBuilder(str);
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new Long(str);
        }
    }
    ,
    INTEGER((Class)Integer.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new Integer(str);
        }
    }
    ,
    SHORT((Class)Short.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new Short(str);
        }
    }
    ,
    BYTE((Class)Byte.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new Byte(str);
        }
    }
    ,
    BYTE_ARRAY((Class)byte[].class){

        @Override
        public String convertToString(Object object) {
            return DatatypeConverter.printBase64Binary((byte[])((byte[])object));
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return DatatypeConverter.parseBase64Binary((String)str);
        }
    }
    ,
    CHARACTER((Class)Character.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            if (str.length() != 1) {
                throw new IllegalArgumentException("Character value must be a string length 1");
            }
            return new Character(str.charAt(0));
        }
    }
    ,
    CHAR_ARRAY((Class)char[].class){

        @Override
        public String convertToString(Object object) {
            return new String((char[])object);
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return str.toCharArray();
        }
    }
    ,
    BOOLEAN((Class)Boolean.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            if ("true".equalsIgnoreCase(str)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Boolean value must be 'true' or 'false', case insensitive");
        }
    }
    ,
    DOUBLE((Class)Double.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new Double(str);
        }
    }
    ,
    FLOAT((Class)Float.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new Float(str);
        }
    }
    ,
    BIG_INTEGER((Class)BigInteger.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new BigInteger(str);
        }
    }
    ,
    BIG_DECIMAL((Class)BigDecimal.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new BigDecimal(str);
        }
    }
    ,
    ATOMIC_LONG((Class)AtomicLong.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            long val = Long.parseLong(str);
            return new AtomicLong(val);
        }
    }
    ,
    ATOMIC_INTEGER((Class)AtomicInteger.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            int val = Integer.parseInt(str);
            return new AtomicInteger(val);
        }
    }
    ,
    ATOMIC_BOOLEAN((Class)AtomicBoolean.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            if ("true".equalsIgnoreCase(str)) {
                return new AtomicBoolean(true);
            }
            if ("false".equalsIgnoreCase(str)) {
                return new AtomicBoolean(false);
            }
            throw new IllegalArgumentException("Boolean value must be 'true' or 'false', case insensitive");
        }
    }
    ,
    LOCALE((Class)Locale.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            String[] split = str.split("_", 3);
            switch (split.length) {
                case 1: {
                    return new Locale(split[0]);
                }
                case 2: {
                    return new Locale(split[0], split[1]);
                }
                case 3: {
                    return new Locale(split[0], split[1], split[2]);
                }
            }
            throw new IllegalArgumentException("Unable to parse Locale: " + str);
        }
    }
    ,
    CLASS((Class)Class.class){

        @Override
        public String convertToString(Object object) {
            return ((Class)object).getName();
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            try {
                return this.getClass().getClassLoader().loadClass(str);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Unable to create class: " + str, ex);
            }
        }
    }
    ,
    PACKAGE((Class)Package.class){

        @Override
        public String convertToString(Object object) {
            return ((Package)object).getName();
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return Package.getPackage(str);
        }
    }
    ,
    CURRENCY((Class)Currency.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return Currency.getInstance(str);
        }
    }
    ,
    TIME_ZONE((Class)TimeZone.class){

        @Override
        public String convertToString(Object object) {
            return ((TimeZone)object).getID();
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return TimeZone.getTimeZone(str);
        }
    }
    ,
    UUID((Class)UUID.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return java.util.UUID.fromString(str);
        }
    }
    ,
    URL((Class)URL.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            try {
                return new URL(str);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }
    ,
    URI((Class)URI.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return java.net.URI.create(str);
        }
    }
    ,
    INET_ADDRESS((Class)InetAddress.class){

        @Override
        public String convertToString(Object object) {
            return ((InetAddress)object).getHostAddress();
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            try {
                return InetAddress.getByName(str);
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
    ,
    FILE((Class)File.class){

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            return new File(str);
        }
    }
    ,
    DATE((Class)Date.class){

        @Override
        public String convertToString(Object object) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String str = f.format(object);
            return str.substring(0, 26) + ":" + str.substring(26);
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            if (str.length() != 29) {
                throw new IllegalArgumentException("Unable to parse date: " + str);
            }
            str = str.substring(0, 26) + str.substring(27);
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            try {
                return f.parseObject(str);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
    ,
    CALENDAR((Class)Calendar.class){

        @Override
        public String convertToString(Object object) {
            if (!(object instanceof GregorianCalendar)) {
                throw new RuntimeException("Unable to convert calendar as it is not a GregorianCalendar");
            }
            GregorianCalendar cal = (GregorianCalendar)object;
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            f.setCalendar(cal);
            String str = f.format(cal.getTime());
            return str.substring(0, 26) + ":" + str.substring(26) + "[" + cal.getTimeZone().getID() + "]";
        }

        @Override
        public Object convertFromString(Class<?> cls, String str) {
            if (str.length() < 31 || str.charAt(26) != ':' || str.charAt(29) != '[' || str.charAt(str.length() - 1) != ']') {
                throw new IllegalArgumentException("Unable to parse date: " + str);
            }
            TimeZone zone = TimeZone.getTimeZone(str.substring(30, str.length() - 1));
            str = str.substring(0, 26) + str.substring(27, 29);
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            GregorianCalendar cal = new GregorianCalendar(zone);
            cal.setTimeInMillis(0L);
            f.setCalendar(cal);
            try {
                f.parseObject(str);
                return f.getCalendar();
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
    ,
    ENUM((Class)Enum.class){

        @Override
        public String convertToString(Object object) {
            return ((Enum)object).name();
        }

        @Override
        public Object convertFromString(Class cls, String str) {
            return Enum.valueOf(cls, str);
        }
    };

    private Class<?> type;

    private JDKStringConverter(Class<?> type) {
        this.type = type;
    }

    Class<?> getType() {
        return this.type;
    }

    @Override
    public String convertToString(Object object) {
        return object.toString();
    }
}

